<?php

set_time_limit(3000); 
 
 
function flattenParts($messageParts, $flattenedParts = array(), $prefix = '', $index = 1, $fullPrefix = true) {

	foreach($messageParts as $part) {
		$flattenedParts[$prefix.$index] = $part;
		if(isset($part->parts)) {
			if($part->type == 2) {
				$flattenedParts = flattenParts($part->parts, $flattenedParts, $prefix.$index.'.', 0, false);
			}
			elseif($fullPrefix) {
				$flattenedParts = flattenParts($part->parts, $flattenedParts, $prefix.$index.'.');
			}
			else {
				$flattenedParts = flattenParts($part->parts, $flattenedParts, $prefix);
			}
			unset($flattenedParts[$prefix.$index]->parts);
		}
		$index++;
	}

	return $flattenedParts;
			
}
/* connect to gmail with your credentials */
$hostname = '{mail.stvat.com:143}INBOX';
$username = 'data@stvat.com'; # e.g somebody@gmail.com
$password = 'Datastvat@123';
 
 
/* try to connect */
$inbox = imap_open($hostname,$username,$password) or die('Cannot connect to email: ' . imap_last_error());
 
 
/* get all new emails. If set to 'ALL' instead 
 * of 'NEW' retrieves all the emails, but can be 
 * resource intensive, so the following variable, 
 * $max_emails, puts the limit on the number of emails downloaded.
 * 
 */
$emails = imap_search($inbox,'ALL');
 
/* useful only if the above search is set to 'ALL' */
$max_emails = 5;
 
 
/* if any emails found, iterate through each email */
if($emails) {
 
    $count = 1;
 
    /* put the newest emails on top */
    rsort($emails);
 
    /* for every email... */
    foreach($emails as $email_number) 
    {
 
        /* get information specific to this email */
        $overview = imap_fetch_overview($inbox,$email_number,0);

        // print_r($overview);
        
        
        echo $overview[0]->from.'</br>';
        echo $overview[0]->message_id.'</br>';
        echo $overview[0]->subject.'</br>';
        echo $overview[0]->date.'</br>';
        
        // echo $overview[0]->from.'</br>';
        // echo $overview[0]->message_id.'</br>';
        // echo $overview[0]->subject.'</br>';
        // echo $overview[0]->date.'</br>';
 
        /* get mail message */
        $message = imap_fetchbody($inbox,$email_number,2);
        
        $structure = imap_fetchstructure($inbox, $email_number);
 
        $flattenedParts = flattenParts($structure->parts);
       
        echo '</br></br>';
        // print_r($flattenedParts);
        echo '</br></br>';
        $attachments = array();
 
        /* if any attachments found... */
        if(isset($flattenedParts->parts) && count($flattenedParts->parts)) 
        {
            for($i = 0; $i < count($flattenedParts->parts); $i++) 
            {
                $attachments[$i] = array(
                    'is_attachment' => false,
                    'filename' => '',
                    'name' => '',
                    'attachment' => ''
                );
 
                if($flattenedParts->parts[$i]->ifdparameters) 
                {
                    foreach($flattenedParts->parts[$i]->dparameters as $object) 
                    {
                        if(strtolower($object->attribute) == 'filename') 
                        {
                            $attachments[$i]['is_attachment'] = true;
                            $attachments[$i]['filename'] = $object->value;
                        }
                    }
                }
 
                if($flattenedParts->parts[$i]->ifparameters) 
                {
                    foreach($flattenedParts->parts[$i]->parameters as $object) 
                    {
                        if(strtolower($object->attribute) == 'name') 
                        {
                            $attachments[$i]['is_attachment'] = true;
                            $attachments[$i]['name'] = $object->value;
                        }
                    }
                }
 
                if($attachments[$i]['is_attachment']) 
                {
                    $attachments[$i]['attachment'] = imap_fetchbody($inbox, $email_number, $i+1);
 
                    /* 4 = QUOTED-PRINTABLE encoding */
                    if($flattenedParts->parts[$i]->encoding == 3) 
                    { 
                        $attachments[$i]['attachment'] = base64_decode($attachments[$i]['attachment']);
                    }
                    /* 3 = BASE64 encoding */
                    elseif($flattenedParts->parts[$i]->encoding == 4) 
                    { 
                        $attachments[$i]['attachment'] = quoted_printable_decode($attachments[$i]['attachment']);
                    }
                }
            }
        }
 
        /* iterate through each attachment and save it */
        foreach($attachments as $attachment)
        {
            if($attachment['is_attachment'] == 1)
            {
                $filename = $attachment['name'];
                echo $filename;
                if(empty($filename)) $filename = $attachment['filename'];
 
                if(empty($filename)) $filename = time() . ".dat";
 
                /* prefix the email number to the filename in case two emails
                 * have the attachment with the same file name.
                 */
                $fp = fopen($email_number . "-" . $filename, "w+");
                fwrite($fp, $attachment['attachment']);
                fclose($fp);
                
            }
 
        }
 
        $header = imap_header($inbox,$count); 
        $body = imap_body($inbox,$count,2);

        // print_r($header);
        // echo '<br/>';
        echo $body;
        if($count++ >= $max_emails) break;
        
    }
 
} 
 

/* close the connection */
imap_close($inbox);
 
echo "Done";
 
?>
<script>

</script>