<?php
use PhpOffice\PhpSpreadsheet\NamedRange;

include 'db/dbmgnt.php';

require 'vendor/autoload.php';

$file_name = "Recurring_Master.xlsm";

$zip_directory = "ref_files/";

$sql = "SELECT a.id,b.practice_name, c.practice_name as Sub_Practice,d.activity_name,

e.form_no+' - '+ e.state_group as Location_Based , f.turnover,

a.effect_from,a.effect_to, a.task_date FROM new_master_recurring a

inner join practice_area b on a.practice_id = b.practice_id

inner join sub_practice_area c on a.sub_practice_id = c.sub_practice_id

inner join activity_table d on a.activity_id = d.activity_id

inner join recu_state_group e on a.location_id = e.id

inner join turnovermaster f on a.turnover_id = f.id

order by a.id";

$Sheet1 = $dbmgnt->Fetch_Result_Set($sql);

$startturnover = 0;
$endturnover = 0;
$sql_turn = "SELECT DISTINCT turnover as turnover  from turnovermaster  WHERE status='1' ";
$result_turn = $dbmgnt->Fetch_Result_Set($sql_turn);
$startturnover = 1;
$countturn = $dbmgnt->Fetch_Result_Set_Count($sql_turn);
$endturnover = $countturn + $startturnover;

$startpractice = 0;
$endpractice = 0;
$sql_practice = "SELECT DISTINCT practice_name as practice  from practice_area  WHERE status='1' ";
$result_practice = $dbmgnt->Fetch_Result_Set($sql_practice);
$startpractice = 1;
$countpractice = $dbmgnt->Fetch_Result_Set_Count($sql_practice);
$endpractice = $countpractice + $startpractice;

$startsubpractice = 0;
$endsubpractice = 0;
$sql_subpractice = "SELECT DISTINCT practice_name as subpractice  from sub_practice_area  WHERE status='1' ";
$result_subpractice = $dbmgnt->Fetch_Result_Set($sql_subpractice);
$startsubpractice = 1;
$countsubpractice = $dbmgnt->Fetch_Result_Set_Count($sql_subpractice);
$endsubpractice = $countsubpractice + $startsubpractice;

$startacivity = 0;
$endactivity = 0;
$sql_acticvity = "SELECT DISTINCT activity_name as activity_name  from activity_table  WHERE status='1' ";
$result_activity = $dbmgnt->Fetch_Result_Set($sql_acticvity);
$startacivity = 1;
$countact = $dbmgnt->Fetch_Result_Set_Count($sql_acticvity);
$endactivity = $countact + $startacivity ;

$startsubacivity = 0;
$endsubactivity = 0;
$sql_subacticvity = "SELECT DISTINCT activity_name as subactivity_name  from sub_activity_table  WHERE status='1' ";
$result_subactivity = $dbmgnt->Fetch_Result_Set($sql_subacticvity);
$startsubacivity = 1;
$countsubact = $dbmgnt->Fetch_Result_Set_Count($sql_subacticvity);
$endsubactivity = $countsubact + $startsubacivity ;


$startloca = 0;
$endloca = 0;
$sql_locy = "SELECT *, CONCAT(form_no, 'State Group -', state_group, 'valid from-', valid_from) AS location FROM `recu_state_group` where status_='1'";
$result_locy = $dbmgnt->Fetch_Result_Set($sql_locy);
$startloca = 1;
$countloc = $dbmgnt->Fetch_Result_Set_Count($sql_locy);
$endloca = $countloc + $startloca ;


$reader = PhpOffice\PhpSpreadsheet\IOFactory::load($zip_directory.$file_name);
$worksheet = $reader->getSheetByName('Sheet1');

$row = 2; 

while($row_data = mysqli_fetch_assoc($Sheet1)) {           
    $col = 1;
    foreach($row_data as $key=>$value) {
        $reader->getSheetByName("Sheet1")->setCellValueByColumnAndRow($col, $row, $value);
        $col++;    
    }
    $row++;
}      

//$sql = "select * from new_master_recurring ";
$sql = "select a.*,b.activity_name from new_master_recurring a
inner join activity_table b on a.activity_id = b.activity_id ";
$Sheet2 = $dbmgnt->Fetch_Result_Set($sql);
$row = 2; 
$col = 1;

while($row_data = mysqli_fetch_assoc($Sheet2)){    

    $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(1, $row, $row_data['id']);

    $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(2, $row, $row_data['recu_type']);

    if($row_data['recu_type'] == "Weekly"){

        $sql_weekly = "select * from recu_weekly where master_id = '".$row_data['id']."' ";
        $set_weekly = $dbmgnt->Fetch_Result_Array($sql_weekly);

        $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow('Q', $row, $set_weekly['day']);

    }

    if($row_data['recu_type'] == "yearly"){        

        $sql_yearly = "select * from recu_yearly where master_id = '".$row_data['id']."' ";
        $set_yearly = $dbmgnt->Fetch_Result_Array($sql_yearly);

        $month_num = $set_yearly['month'];
        $month_name = date("F", mktime(0, 0, 0, $month_num, 10));

        $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(4, $row, $month_name);
        $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(5, $row, $set_yearly['date']);

    }

    if($row_data['recu_type'] == "monthly"){        

        $sql_monthly = "select * from recu_monthly where master_id = '".$row_data['id']."' ";
        $set_monthly = $dbmgnt->Fetch_Result_Array($sql_monthly);                

        $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(16, $row, $set_monthly['date']);
    }

    if($row_data['recu_type'] == "quarterly"){        

        $sql_quarterly = "select * from recu_quarterly where master_id = '".$row_data['id']."' ";
        $set_sql_quarterly = $dbmgnt->Fetch_Result_Array($sql_quarterly);      

        if($set_sql_quarterly['compliance'] == 'days' ){
            $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(7, $row, $set_sql_quarterly['Compliance_date']);
        }

        if($set_sql_quarterly['compliance'] == 'specified' ){

            $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(8, $row, $set_sql_quarterly['q1_month']);
            $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(9, $row, $set_sql_quarterly['q1_days']);
            $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(10, $row, $set_sql_quarterly['q2_month']);
            $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(11, $row, $set_sql_quarterly['q2_days']);
            $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(12, $row, $set_sql_quarterly['q3_month']);
            $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(13, $row, $set_sql_quarterly['q3_days']);
            $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(14, $row, $set_sql_quarterly['q4_month']);
            $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(15, $row, $set_sql_quarterly['q4_days']);

        }
       

    }

    $reader->getSheetByName("Sheet3")->setCellValueByColumnAndRow(1, $row, $row_data['id']);
    $reader->getSheetByName("Sheet3")->setCellValueByColumnAndRow(2, $row, $row_data['activity_name']);

    $sql_sheet3 = "select * from recuMaster_assign where recu_masterId = ".$row_data['id']." ";
    $set_sheet3 = $dbmgnt->Fetch_Result_Array($sql_sheet3);
  

    if(isset($set_sheet3['client_ids']) && $set_sheet3['client_ids'] != null){

        $sql_client = "select distinct client_name from client_details where client_id in ('".$set_sheet3['client_ids']."')";
        $set_client = $dbmgnt->Fetch_Result_Set($sql_client);

        $client_list = '';

        while($row_client = mysqli_fetch_assoc($set_client)){

            $client_list .= $row_client['client_name'].'#';

        }

    }
   

    if(isset($set_sheet3['staff_ids']) && $set_sheet3['staff_ids'] != null){

        $sql_staff = "select distinct staff_name from office_staff where staff_id in ('".$set_sheet3['staff_ids']."')";
        $set_staff = $dbmgnt->Fetch_Result_Set($sql_staff);

        $staff_list = '';

        while($row_staff = mysqli_fetch_assoc($set_staff)){

            $staff_list .= $row_staff['staff_name'].'#';

        }

    }

    
    $reader->getSheetByName("Sheet3")->setCellValueByColumnAndRow(3, $row, $client_list);
    $reader->getSheetByName("Sheet3")->setCellValueByColumnAndRow(4, $row, $staff_list);

    $row++;     
}

$k = 2;
$row = 2; 
    $validation = $reader->getSheetByName("Recurring")->getCell('F'.$row)
    ->getDataValidation();
    $validation->setType( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_LIST );
    $validation->setErrorStyle( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_INFORMATION );
    $validation->setAllowBlank(false);
    $validation->setShowInputMessage(true);
    $validation->setShowErrorMessage(true);
    $validation->setShowDropDown(true);
    $validation->setErrorTitle('Input error');
    $validation->setError('Value is not in list.');
    $validation->setPromptTitle('Pick from list');
    $validation->setPrompt('Please pick a value from the drop-down list.');
    $validation->setFormula1('=turnover');
    while($row_data1 = mysqli_fetch_assoc($result_turn)){
        $reader->getSheetByName("Sheet3")->setCellValueByColumnAndRow(12, $k, $row_data1['turnover']);
        $reader->addNamedRange(new NamedRange('turnover',$reader->getSheetByName("Sheet3"),'$L$2:$L$'.$endturnover));
        $reader->getSheetByName("Recurring")->getCell('F'.$row)->setDataValidation(clone $validation);
        $k++;
        $row++;   
        
    }

$k3 = 2;
$row5 = 2; 
    $validation = $reader->getSheetByName("Recurring")->getCell('B'.$row5)
    ->getDataValidation();
    $validation->setType( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_LIST );
    $validation->setErrorStyle( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_INFORMATION );
    $validation->setAllowBlank(false);
    $validation->setShowInputMessage(true);
    $validation->setShowErrorMessage(true);
    $validation->setShowDropDown(true);
    $validation->setErrorTitle('Input error');
    $validation->setError('Value is not in list.');
    $validation->setPromptTitle('Pick from list');
    $validation->setPrompt('Please pick a value from the drop-down list.');
    $validation->setFormula1('=Practice_Names');
    while($row_practice = mysqli_fetch_assoc($result_practice)){
        $reader->getSheetByName("Sheet3")->setCellValueByColumnAndRow(13, $k3, $row_practice['practice']);
        $reader->addNamedRange(new NamedRange('Practice_Names',$reader->getSheetByName("Sheet3"),'$M$2:$M$'.$endpractice));
        $reader->getSheetByName("Recurring")->getCell('B'.$row5)->setDataValidation(clone $validation);
        $k3++;
        $row5++;     
        
    }
$k4 = 2;
$row15 = 2; 
    $validation = $reader->getSheetByName("Recurring")->getCell('C'.$row15)
    ->getDataValidation();
    $validation->setType( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_LIST );
    $validation->setErrorStyle( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_INFORMATION );
    $validation->setAllowBlank(false);
    $validation->setShowInputMessage(true);
    $validation->setShowErrorMessage(true);
    $validation->setShowDropDown(true);
    $validation->setErrorTitle('Input error');
    $validation->setError('Value is not in list.');
    $validation->setPromptTitle('Pick from list');
    $validation->setPrompt('Please pick a value from the drop-down list.');
    $validation->setFormula1('=subpracticename');
    while($row_subpractice = mysqli_fetch_assoc($result_subpractice)){
        $reader->getSheetByName("Sheet3")->setCellValueByColumnAndRow(14, $k4, $row_subpractice['subpractice']);
        $reader->addNamedRange(new NamedRange('subpracticename',$reader->getSheetByName("Sheet3"),'$N$2:$N$'.$endsubpractice));
        $reader->getSheetByName("Recurring")->getCell('C'.$row15)->setDataValidation(clone $validation);
        $k4++;
        $row15++;     
        
    }

$k5 = 2;
$row16 = 2; 
    $validation = $reader->getSheetByName("Recurring")->getCell('D'.$row16)
    ->getDataValidation();
    $validation->setType( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_LIST );
    $validation->setErrorStyle( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_INFORMATION );
    $validation->setAllowBlank(false);
    $validation->setShowInputMessage(true);
    $validation->setShowErrorMessage(true);
    $validation->setShowDropDown(true);
    $validation->setErrorTitle('Input error');
    $validation->setError('Value is not in list.');
    $validation->setPromptTitle('Pick from list');
    $validation->setPrompt('Please pick a value from the drop-down list.');
    $validation->setFormula1('=activityName');
    while($row_actvity = mysqli_fetch_assoc($result_activity)){
        $reader->getSheetByName("Sheet3")->setCellValueByColumnAndRow(15, $k5, $row_actvity['activity_name']);
        $reader->addNamedRange(new NamedRange('activityName',$reader->getSheetByName("Sheet3"),'$O$2:$O$'.$endactivity));
        $reader->getSheetByName("Recurring")->getCell('D'.$row16)->setDataValidation(clone $validation);
        $k5++;
        $row16++;     
    }

$k51 = 2;
$row161 = 2; 
    $validation = $reader->getSheetByName("Recurring")->getCell('E'.$row161)
    ->getDataValidation();
    $validation->setType( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_LIST );
    $validation->setErrorStyle( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_INFORMATION );
    $validation->setAllowBlank(false);
    $validation->setShowInputMessage(true);
    $validation->setShowErrorMessage(true);
    $validation->setShowDropDown(true);
    $validation->setErrorTitle('Input error');
    $validation->setError('Value is not in list.');
    $validation->setPromptTitle('Pick from list');
    $validation->setPrompt('Please pick a value from the drop-down list.');
    $validation->setFormula1('=locationbased');
    while($row_locy = mysqli_fetch_assoc($result_locy)){
        $reader->getSheetByName("Sheet3")->setCellValueByColumnAndRow(16, $k51, $row_locy['location']);
        $reader->addNamedRange(new NamedRange('locationbased',$reader->getSheetByName("Sheet3"),'$P$2:$P$'.$endloca));
        $reader->getSheetByName("Recurring")->getCell('E'.$row161)->setDataValidation(clone $validation);
        $k51++;
        $row161++;     
    }

$B = 2;
$rowB = 2; 
    while($row_subact = mysqli_fetch_assoc($result_subactivity)){
        $reader->getSheetByName("Sheet3")->setCellValueByColumnAndRow(17, $B, $row_subact['subactivity_name']);
        $B++;
   
    $reader->addNamedRange(new NamedRange('sub_Activity',$reader->getSheetByName("Sheet3"),'$Q$2:$Q$'.$endsubactivity));
    
    $validation = $reader->getSheetByName("Recurring")->getCell('J'.$rowB)
    ->getDataValidation();
    $validation->setType( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_LIST );
    $validation->setErrorStyle( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_INFORMATION );
    $validation->setAllowBlank(false);
    $validation->setShowInputMessage(true);
    $validation->setShowErrorMessage(true);
    $validation->setShowDropDown(true);
    $validation->setErrorTitle('Input error');
    $validation->setError('Value is not in list.');
    $validation->setPromptTitle('Pick from list');
    $validation->setPrompt('Please pick a value from the drop-down list.');
    $validation->setFormula1('=sub_Activity');
    $rowB++;     
}
$writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($reader);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($file_name).'"');
$writer->save('php://output');

?>