
$(function() {    

    $("html").on("dragover", function(e) {
        e.preventDefault();
        e.stopPropagation();
        $("h5").text("Drag here");
    });
    $("html").on("drop", function(e) { e.preventDefault(); e.stopPropagation(); });
    // Drag enter
    $('.upload-area').on('dragenter', function (e) {
        e.stopPropagation();
        e.preventDefault();
        $("h5").text("Drop");
    });
    // Drag over
    $('.upload-area').on('dragover', function (e) {
        e.stopPropagation();
        e.preventDefault();
        $("h5").text("Drop");
    });
    // Drop
    $('.upload-area').on('drop', function (e) {
        e.stopPropagation();
        e.preventDefault();
        var file = e.originalEvent.dataTransfer.files;
        var extension =  file[0].name.split('.').pop().toLowerCase();    
        var validFileExtensions = ['sql'];
        if ($.inArray(extension, validFileExtensions) == -1){
            $(this).replaceWith($(this).val('').clone(true));
            swal('Warning',"Please select valid file");
        }
        else{
            var dispData = "<div> File Name :"+file[0].name+" </div><div> Size :"+convertSize(file[0].size)+"</div>";
            $("h5").html(dispData);
            var fd = new FormData();
            fd.append('file', file[0]);
            uploadData(fd);
        }
    });

    $("#uploadfile").click(function(){
        $("#file").click();
    });
    // file selected
    $("#file").change(function(){    
        var extension =  $(this).val().split('.').pop().toLowerCase();    
        var validFileExtensions = ['sql'];
        if ($.inArray(extension, validFileExtensions) == -1){
            $(this).replaceWith($(this).val('').clone(true));
            swal('warning',"Please select valid file");
        }
        else{            
            var file_data = $('#file').prop('files')[0];
            var fd = new FormData();
            fd.append('file', file_data);
            uploadData(fd);
        }
    });

});
// Bytes conversion
function convertSize(size) {
var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'];
if (size == 0) return '0 Byte';
var i = parseInt(Math.floor(Math.log(size) / Math.log(1024)));
return Math.round(size / Math.pow(1024, i), 2) + ' ' + sizes[i];
}

function uploadData(formdata){

    $.ajax({
        //url: 'tools/ReadExcel.php',
        url: 'tools/save_sql.php',
        type: 'post',
        data: formdata,
        contentType: false,
        processData: false,
        datatype: 'json',
        success: function (response) {
            var res = JSON.parse(response);
            var msg = res.message;
           // var msg = response.message;
            console.log(msg);
            if(response.status_code == 0){
                swal(msg);
            }
            else{
                swal(msg);
            }
        }
    });

    
}


