<?php
use PhpOffice\PhpSpreadsheet\NamedRange;
include 'db/dbmgnt.php';
require 'vendor/autoload.php';
$file_name = "Statuary_Master.xlsx";
$zip_directory = "ref_files/";
$sql = "SELECT DISTINCT a.Newstatuary_master_id,a.Activity_id,a.Statuary_month,a.Statuary_days,a.Condonable_date,a.Condonable_month,a.Condonable_days,a.Notes,b.activity_name as activity_name from statuary_due_date_master a INNER JOIN activity_table b on a.Activity_id=b.activity_id WHERE a.status='1' and b.status='1'";
$result = $dbmgnt->Fetch_Result_Set($sql);

$sql_activity = "SELECT DISTINCT activity_name from activity_table  WHERE status='1' ";
$result_activity = $dbmgnt->Fetch_Result_Set($sql_activity);

$reader = PhpOffice\PhpSpreadsheet\IOFactory::load($zip_directory.$file_name);
$worksheet = $reader->getSheetByName('Sheet1');
$row = 2; 
while($row_data = mysqli_fetch_assoc($result)) {           
    $col = 1;
    foreach($row_data as $key=>$value) {
        $reader->getSheetByName("Sheet1")->setCellValueByColumnAndRow($col, $row, $value);
        $col++;               
    }
    $row++;
}  

$h= 2;
$row1 = 2; 
    while($row_data1 = mysqli_fetch_assoc($result_activity)){
        $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(2, $h, $row_data1['activity_name']);
        $h++;
    
    $reader->addNamedRange(new NamedRange('activitynames',$reader->getSheetByName("Sheet2"),'$B$2:$B$31'));
    
    $validation = $reader->getSheetByName("statuary_duedate")->getCell('B'.$row1)
    ->getDataValidation();
    $validation->setType( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_LIST );
    $validation->setErrorStyle( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_INFORMATION );
    $validation->setAllowBlank(false);
    $validation->setShowInputMessage(true);
    $validation->setShowErrorMessage(true);
    $validation->setShowDropDown(true);
    $validation->setErrorTitle('Input error');
    $validation->setError('Value is not in list.');
    $validation->setPromptTitle('Pick from list');
    $validation->setPrompt('Please pick a value from the drop-down list.');
    $validation->setFormula1('=activitynames');
    $row1++;     
}



$writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($reader);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($file_name).'"');
$writer->save('php://output');

?>