<?php
use PhpOffice\PhpSpreadsheet\NamedRange;
include 'db/dbmgnt.php';
require 'vendor/autoload.php';
$file_name = "Client_Details.xlsx";
$zip_directory = "ref_files/";
$sql = "SELECT DISTINCT a.client_id,c.client_group_name,a.client_name,a.client_short,a.client_address,a.clientstate, a.client_country,b.contact_name,b.contact_mobile,b.contact_landline,b.contact_email,b.user_login_id,b.user_pwd from client_details a INNER JOIN client_contact b on a.client_id = b.client_id inner join client_group_table c on a.client_group_id = c.id WHERE a.status='1' and b.status='1'";
$result = $dbmgnt->Fetch_Result_Set($sql);

$cligrpcount = "";
$grpstartvalue = "";
$grpstartvalue = 1;
$sql_cligrp = "SELECT DISTINCT client_group_name FROM client_group_table WHERE status='1'";
$result_grp = $dbmgnt->Fetch_Result_Set($sql_cligrp);
$cligrpcount1 = $dbmgnt->Fetch_Result_Set_Count($sql_cligrp);
$cligrpcount = $cligrpcount1 + $grpstartvalue;

$statecount = "";
$statestartvalue = "";
$statestartvalue = 1;
$sql_state = "SELECT DISTINCT state_name as state_name  from sp_statemaster  WHERE status_='1' order by state_name ";
$result_state = $dbmgnt->Fetch_Result_Set($sql_state);
$count = $dbmgnt->Fetch_Result_Set_Count($sql_state);
$statecount = $count + $statestartvalue;


$reader = PhpOffice\PhpSpreadsheet\IOFactory::load($zip_directory.$file_name);
$worksheet = $reader->getSheetByName('Sheet1');
$row = 2; 
while($row_data = mysqli_fetch_assoc($result)) {           
    $col = 1;
    foreach($row_data as $key=>$value) {
        $reader->getSheetByName("Sheet1")->setCellValueByColumnAndRow($col, $row, $value);
        $col++;               
    }
    $row++;
}     

$h= 2;
$row1 = 2; 
    while($row_client = mysqli_fetch_assoc($result_grp)){
        $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(2, $h, $row_client['client_group_name']);
        $h++;
    
    $reader->addNamedRange(new NamedRange('clientgrp',$reader->getSheetByName("Sheet2"),'$B$2:$B$'.$cligrpcount));
    
    $validation = $reader->getSheetByName("Client_Details")->getCell('B'.$row1)
    ->getDataValidation();
    $validation->setType( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_LIST );
    $validation->setErrorStyle( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_INFORMATION );
    $validation->setAllowBlank(false);
    $validation->setShowInputMessage(true);
    $validation->setShowErrorMessage(true);
    $validation->setShowDropDown(true);
    $validation->setErrorTitle('Input error');
    $validation->setError('Value is not in list.');
    $validation->setPromptTitle('Pick from list');
    $validation->setPrompt('Please pick a value from the drop-down list.');
    $validation->setFormula1('=clientgrp');
    $row1++;     
}

$j= 2;
$row11 = 2; 
    while($row_data1 = mysqli_fetch_assoc($result_state)){
        $reader->getSheetByName("Sheet2")->setCellValueByColumnAndRow(1, $j, $row_data1['state_name']);
        $j++;
    
    $reader->addNamedRange(new NamedRange('Statename',$reader->getSheetByName("Sheet2"),'$A$2:$A$'.$statecount));
    
    $validation = $reader->getSheetByName("Client_Details")->getCell('F'.$row11)
    ->getDataValidation();
    $validation->setType( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_LIST );
    $validation->setErrorStyle( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_INFORMATION );
    $validation->setAllowBlank(false);
    $validation->setShowInputMessage(true);
    $validation->setShowErrorMessage(true);
    $validation->setShowDropDown(true);
    $validation->setErrorTitle('Input error');
    $validation->setError('Value is not in list.');
    $validation->setPromptTitle('Pick from list');
    $validation->setPrompt('Please pick a value from the drop-down list.');
    $validation->setFormula1('=Statename');
    $row11++;     
}




$writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($reader);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($file_name).'"');
$writer->save('php://output');

?>