<?php
error_reporting(E_ERROR | E_PARSE);
require '../../vendor/autoload.php';
include '../../db/dbmgnt.php';
include '../../pages/master_data.php';
date_default_timezone_set('Asia/Kolkata');
$dt = new DateTime();
if(isset($_FILES['file'])){
    $valid_ext = array('xlsm','xlsx','xls','xlsb');
    $folderName = date('d-m-y');
    $zip_directory = "../files/excel/".$folderName."/";
    $filename = $_FILES['file']['name'];
    $ext = pathinfo($filename, PATHINFO_EXTENSION);
    $failed_rows = 0;
    if(in_array(strtolower($ext),$valid_ext)){
        $tmp_name = $_FILES['file']['tmp_name'];
        $ext = pathinfo($tmp_name, PATHINFO_EXTENSION);
        $file = basename($tmp_name,".".$ext);
        if(!is_dir($zip_directory)){
            mkdir($zip_directory, 7555, true);
        }
        move_uploaded_file($tmp_name,$zip_directory.$file);
        $reader = PhpOffice\PhpSpreadsheet\IOFactory::load($zip_directory.$file);
        $rows = $reader->getSheet(0)->getRowIterator();
        foreach($rows as $row => $value){
            if($row > 1){
                $prac_name = $reader->getActiveSheet()->getCellByColumnAndRow(2, $row)->getCalculatedValue();
                if($prac_name != ''){
                    $data = array(
                        'practice_name' => $prac_name,
                        'practice_short' => $reader->getActiveSheet()->getCellByColumnAndRow(3, $row)->getCalculatedValue(),
                        'created_by' => 'sytem Imported',
                        'created_date' => $dt->format('Y-m-d H:i:s'),
                        'updated_by' => 'sytem Imported',
                        'status' => '1',
                    );
                    $result = $dbmgnt->f_mysql_insert_array('practice_area',$data);
                    if(!$result['mysqli_error']){

                    }
                    else{
                        $failed_rows .= $row.",";
                    }
                }
                
            }
        }

        if($failed_rows == ''){
            $return_array = array(
                'status_code' => '1',
                'status_info' => 'All Records Imported Successfully'
            );
            echo $jsonformat = json_encode($return_array);
            exit;
        }
        else{
            $return_array = array(
                'status_code' => '0',
                'status_info' => $failed_rows.' Those Rows are not imported'
            );
            echo $jsonformat = json_encode($return_array);
            exit;
        }
    }
    else{
        $return_array = array(
            'status_code' => '0',
            'status_info' => 'Failed to load File..'
        );
        echo $jsonformat = json_encode($return_array);
        exit;
    }
}