$(function () {

    // $(document).ajaxStart(function () {
    //     $(".pr_myDivLoading").show();
    // }).ajaxStop(function () {
    //     $(".pr_myDivLoading").hide();
    // });
    //$('.pr_myDivLoading').hide();    
    
    $("html").on("dragover", function (e) {
        e.preventDefault();
        e.stopPropagation();
        $("h5").text("Drag here");
    });

    $("html").on("drop", function (e) { e.preventDefault(); e.stopPropagation(); });

    $('.upload-area').on('dragenter', function (e) {
        e.stopPropagation();
        e.preventDefault();
        $("h5").text("Drop");
    });

    $('.upload-area').on('dragover', function (e) {
        e.stopPropagation();
        e.preventDefault();
        $("h5").text("Drop");
    });

    $('.upload-area').on('drop', function (e) {
        e.stopPropagation();
        e.preventDefault();
        var file = e.originalEvent.dataTransfer.files;
        var extension = file[0].name.split('.').pop().toLowerCase();
        var validFileExtensions = ['xlsm', 'xlsx', 'xls', 'xlsb'];
        if ($.inArray(extension, validFileExtensions) == -1) {
            $(this).replaceWith($(this).val('').clone(true));
            swal('Warning', "Please select valid file");
        }
        else {
            var dispData = "<div> File Name :" + file[0].name + " </div><div> Size :" + convertSize(file[0].size) + "</div>";
            $("h5").html(dispData);
            var fd = new FormData();
            fd.append('file', file[0]);
            uploadData(fd);
        }
    });

    $("#uploadfile").click(function () {
        $("#file").click();
    });

    $("#file").change(function () {
        var extension = $(this).val().split('.').pop().toLowerCase();
        var validFileExtensions = ['xlsm', 'xlsx', 'xls', 'xlsb'];
        if ($.inArray(extension, validFileExtensions) == -1) {
            $(this).replaceWith($(this).val('').clone(true));
            swal('warning', "Please select valid file");
        }
        else {
            var file_data = $('#file').prop('files')[0];
            var fd = new FormData();
            fd.append('file', file_data);
            uploadData(fd);
        }
    });


});

function convertSize(size) {
    var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'];
    if (size == 0) return '0 Byte';
    var i = parseInt(Math.floor(Math.log(size) / Math.log(1024)));
    return Math.round(size / Math.pow(1024, i), 2) + ' ' + sizes[i];
}

function uploadData(formdata) {

    var loc = '';
    var opt = $('#drp_master').val();

    if(opt == 0 || opt == undefined){
        swal('Please select master ');
        throw new Error("Something went badly wrong!");
    }
    if(opt == 1){
        loc = 'tools/lms_master/clientMaster.php';
    }
    else if(opt == 6){
        loc = 'tools/lms_master/clientgroupMaster.php';
    }
    else if(opt == 2){
        loc = 'tools/lms_master/practiceMaster.php'; 
    }
    else if(opt == 3){
        loc = 'tools/lms_master/subpracticeMaster.php'; 
    } 
    else if(opt == 8){
        loc = 'tools/lms_master/servicecategory.php'; 
    } 
    else if(opt == 9){
        loc = 'tools/lms_master/office_master.php'; 
    } 
    else if(opt == 10){
        loc = 'tools/lms_master/statuary_master.php'; 
    } 
    else if(opt == 11){
        loc = 'tools/lms_master/internal_master.php'; 
    }
    else if(opt == 12){
        loc = 'tools/lms_master/extension_master.php'; 
    }    
    
    $.ajax({
        //url: 'tools/ReadExcel.php',
        url: loc,
        type: 'post',
        data: formdata,
        contentType: false,
        processData: false,
        datatype: 'json',
        success: function (response) {
            var res = JSON.parse(response);
            var msg = res.status_info;
            console.log(msg);
            if(response.status_code == 0){
                swal(msg);
            }
            else{
                swal(msg);
            }
        }
    });
}