
$(function() {    
    $(document).ajaxStart(function () {
        $(".pr_myDivLoading").show();
    }).ajaxStop(function () {
        $(".pr_myDivLoading").hide();
    });

    $("html").on("dragover", function(e) {
        e.preventDefault();
        e.stopPropagation();
        $("h5").text("Drag here");
    });
    $("html").on("drop", function(e) { e.preventDefault(); e.stopPropagation(); });
    // Drag enter
    $('.upload-area').on('dragenter', function (e) {
        e.stopPropagation();
        e.preventDefault();
        $("h5").text("Drop");
    });
    // Drag over
    $('.upload-area').on('dragover', function (e) {
        e.stopPropagation();
        e.preventDefault();
        $("h5").text("Drop");
    });
    // Drop
    $('.upload-area').on('drop', function (e) {
        e.stopPropagation();
        e.preventDefault();
        var file = e.originalEvent.dataTransfer.files;
        var extension =  file[0].name.split('.').pop().toLowerCase();    
        var validFileExtensions = ['xlsm','xlsx','xls','xlsb' ];
        if ($.inArray(extension, validFileExtensions) == -1){
            $(this).replaceWith($(this).val('').clone(true));
            swal('Warning',"Please select valid file");
        }
        else{
            var dispData = "<div> File Name :"+file[0].name+" </div><div> Size :"+convertSize(file[0].size)+"</div>";
            $("h5").html(dispData);
            var fd = new FormData();
            fd.append('file', file[0]);
            uploadData(fd);
        }
    });

    $("#uploadfile").click(function(){
        $("#file").click();
    });
    // file selected
    $("#file").change(function(){    
        var extension =  $(this).val().split('.').pop().toLowerCase();    
        var validFileExtensions = ['xlsm','xlsx','xls','xlsb' ];
        if ($.inArray(extension, validFileExtensions) == -1){
            $(this).replaceWith($(this).val('').clone(true));
            swal('warning',"Please select valid file");
        }
        else{            
            var file_data = $('#file').prop('files')[0];
            var fd = new FormData();
            fd.append('file', file_data);
            uploadData(fd);
        }
    });

});
// Bytes conversion
function convertSize(size) {
var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'];
if (size == 0) return '0 Byte';
var i = parseInt(Math.floor(Math.log(size) / Math.log(1024)));
return Math.round(size / Math.pow(1024, i), 2) + ' ' + sizes[i];
}

function uploadData(formdata){
    $.ajax({
        url: 'tools/ReadExcel.php',
        type: 'post',
        data: formdata,
        contentType: false,
        processData: false,        
        success: function(response){                       
            $('.Main').hide();
            $('.Second').removeClass('hide');
            $('.Second').html(response);
        }
    });
}

function printQR(data){
    var details = data.json;    
    var loc = data.loc;    
    $('#hdn_JsonUrl').val(post_data);
    var post_data = details.SignedQRCode;
    $.ajax({
        url : 'qr/index.php?data='+post_data,
        type : 'GET',        
        success : function(response){
            $('.qrcode').html(response);           
            $('#hdn_JsonData').val(post_data);
        }
    });
                
}
function addThumbnail(data){
    $("#uploadfile h5").remove(); 
    var len = $("#uploadfile div.thumbnail").length;
    var num = Number(len);
    num = num + 1;
    var name = data.name;
    var size = convertSize(data.size);
    var src = data.src;
    // Creating an thumbnail
    $("#uploadfile").append('<div id="thumbnail_'+num+'" class="thumbnail"></div>');
    $("#thumbnail_"+num).append('<img src="'+src+'" width="100%" height="78%">');
    $("#thumbnail_"+num).append('<span class="size">'+size+'<span>');

}
function LoadList(){
  $.ajax({
    url: 'pages/list_inv.php',     
    //dataType: 'text',  
    //cache: false,
    //contentType: false,
    //processData: false,
    //            data: form_data,                         
    //type: 'post',
    success: function(php_script_response){                
      $('#ListInvoices').html(php_script_response);
      $('.tesla').DataTable();
    }
  });
}