<!DOCTYPE html>
<html>

<head>
	<meta content="initial-scale=1, maximum-scale=1,
		user-scalable=0" name="viewport" />

	<meta name="viewport" content="width=device-width" />

	<!--Datatable plugin CSS file -->
	<link rel="stylesheet" href=
"https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css" />

	<!--jQuery library file -->
	<script type="text/javascript"
		src="https://code.jquery.com/jquery-3.5.1.js">
	</script>

	<!--Datatable plugin JS library file -->
	<script type="text/javascript" src=
"https://cdn.datatables.net/1.10.22/js/jquery.dataTables.min.js">
	</script>

	<style>
		td.details-control {
			/* Image in the first column to
				indicate expand*/
			background: url('images/more.png')
				no-repeat center;
				
			cursor: pointer;
		}

		tr.shown td.details-control {
			background: url('images/shrinkdata.PNG')
				no-repeat center;
		}
	</style>

</head>

<body>
	<h2>
		Display child row detailed
		information using DataTable
	</h2>
	
	<!--HTML tables with employee data-->
	<table id="tableID" class="display"
		style="width:100%">
		
		<thead>
			<tr>
				<th></th>
				<th>Name</th>
				<th>Designation</th>
				<th>City</th>
				<th>Salary</th>
			</tr>
		</thead>

	</table>

	<script>

		/* Function for child row details*/
		function getChildRow(data) {
			
			// `data` is the data object for the row
			return '<table cellpadding="5" cellspacing="0"'
				+ ' style="padding-left:50px;">' +
				'<tr>' +
				'<td>Full name:</td>' +
				'<td>' + data.name + '</td>' +
				'</tr>' +
				'<tr>' +
				'<td>Address in detail:</td>' +
				'<td>' + data.address + '</td>' +
				'</tr>' +
				'<tr>' +
				'<td>Extra details like ID:</td>' +
				'<td>' + data.employee_id + '</td>' +
				'</tr>' +
				'</table>';
		}

		$(document).ready(function () {
			
			/* Initialization of datatables */
			var table = $('#tableID').DataTable({
				"ajax": "nestedData.txt",
				"columns": [{
					"className": 'details-control',
					"orderable": true,
					"data": null,
					"defaultContent": ''
				},
					{ "data": "name" },
					{ "data": "designation" },
					{ "data": "city" },
					{ "data": "salary" }
				],
				"order": [[1, 'asc']]
			});

			// Click events for expanding and
			// closing using up/down arrows
			$('#tableID tbody').on('click',
			'td.details-control', function () {

				var tr = $(this).closest('tr');
				var row = table.row(tr);

				if (row.child.isShown()) {

					// Closing the already opened row		
					row.child.hide();

					// Removing class to hide
					tr.removeClass('shown');
				}
				else {

					// Show the child row for detail
					// information
					row.child(getChildRow(row.data())).show();

					// To show details,add the below class
					tr.addClass('shown');
				}
			});
		});		
	</script>
</body>

</html>
