<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.6.1/dist/sweetalert2.all.min.js"></script>

<form enctype="multipart/form-data" class="form-horizontal" method="post" id="add_statename_master"
    name="add_statename_master" action="javascript:;">
    <div class="form-group">
        <label class="control-label col-lg-4">Enter State Code<em class="required">&nbsp;*</em></label>
        <div class="col-lg-5">
            <!-- <input type="text" id="state_code" name="state_code" class="form-control"> -->
            <input type="number" id="state_code" name="state_code" class="form-control" pattern="/^-?\d+\.?\d*$/"
                min="1" max="99" placeholder="State Code" onKeyPress="if(this.value.length==2) return false;" />
            <label for="state_code"></label>
            <input type="hidden" name="substatecodeHdn" id="substatecodeHdn" value="false" />
            <input type="hidden" name="gcodeHdn" id="gcodeHdn" value="" />
        </div>
    </div>
    <div class="form-group">
        <label class="control-label col-lg-4">Enter State Name<em class="required">&nbsp;*</em></label>
        <div class="col-lg-5">
            <input type="text" id="state_name" name="state_name" class="form-control">
            <label for="state_name"></label>
            <input type="hidden" name="substateHdn" id="substateHdn" value="false" />
            <input type="hidden" name="gHdn" id="gHdn" value="" />
        </div>
    </div>
    <p class="require" style="text-align:center;"><em class="required">* </em>Required Fields</p>

    <div class="form-group" style="text-align:center;">
        <label class="control-label col-lg-4" style=" visibility: hidden;"></label>
        <div class="col-lg-4">
            <input type="submit" value="Add" class="button btn-primary " style="width:50px;line-height: 30px;"
                name="addstatemastersubmit" id="addstatemastersubmit">
        </div>
    </div>
</form>
<script>
/** statecode checker **/
$('#state_code').change(function() {

    var name = $(this).val();


    var label = $(this).next();

    if (name.length > 0) {

        label.html('Loading..');

        var UrlToPass = 'action=statecode&name=' + name;

        $.ajax({

            type: 'POST',

            data: UrlToPass,

            url: 'PHP/compliance/statemaster_checker.php',

            success: function(responseText) {

                if ($.trim(responseText) === 0 || $.trim(responseText) == '0') {

                    label.html("<span class='success'>State Code available</span>");

                    $('#substatecodeHdn').val(true);
                    $('#gcodeHdn').val(0);

                } else if ($.trim(responseText) > 0 || $.trim(responseText) == '1') {

                    label.html("<span class='error'>State Code already Exisits</span>");

                    $('#substatecodeHdn').val(false);
                    $('#gcodeHdn').val(1);

                }

            }

        });

    }

    if (name.length == 0) {

        label.html('');

    }

})

/** stateName checker **/
$('#state_name').on('keyup', function() {

    var name1 = $(this).val();

    var name = name1.toLowerCase();

    var label = $(this).next();

    if (name.length > 2) {

        label.html('Loading..');

        var UrlToPass = 'action=statename&name=' + name;

        $.ajax({

            type: 'POST',

            data: UrlToPass,

            url: 'PHP/compliance/stateName_checker.php',

            success: function(responseText) {

                if ($.trim(responseText) === 0 || $.trim(responseText) == '0') {

                    label.html("<span class='success'>State Name available</span>");

                    $('#substateHdn').val(true);
                    $('#gHdn').val(0);

                } else if ($.trim(responseText) > 0 || $.trim(responseText) == '1') {

                    label.html("<span class='error'>State Name already Exisits</span>");

                    $('#substateHdn').val(false);
                    $('#gHdn').val(1);

                }

            }

        });

    } else {

        label.html('Enter atleast 3 characters');
        $('#gHdn').val(3);

    }

    if (name.length == 0) {

        label.html('');

    }

})

function chk_add_statemasterValidity() {
    var state_code = document.getElementById('state_code').value;
    var state_name = document.getElementById('state_name').value;
    var gcodeHdn = document.getElementById('gcodeHdn').value;
    var gHdn = document.getElementById('gHdn').value;



    if (state_code == "") {
        Swal.fire({
            icon: 'error',
            text: 'Please Enter State Code',
        })
    } else if (state_name == "") {
        Swal.fire({
            icon: 'error',
            text: 'Please Enter State name',
        })
    } else if (gcodeHdn == "1") {
        Swal.fire({
            icon: 'error',
            text: 'State code already exists.please enter another name',
        })
    } else if (gHdn == "1") {
        Swal.fire({
            icon: 'error',
            text: 'State name already exists.please enter another name',
        })
    } else if (gHdn == "3") {
        Swal.fire({
            icon: 'error',
            text: 'State Name less than 3 characters .please Enter atleast 3 characters',
        })
    } else {
        return true;
    }
}
$('#addstatemastersubmit').click(function() {
    if (chk_add_statemasterValidity()) {
        $('#addstatemastersubmit').prop('disabled', 'true');
        var params = {};
        $("#add_statename_master").find('input,textarea').each(function() {
            params[$(this).attr('name')] = $.trim($(this).val());
        });
        params['from'] = 'insert';
        $.ajax({
            type: "POST",
            url: "PHP/compliance/statemaster_operations.php",
            data: params,
            dataType: "json",
            success: function(res) {
                if (res.status_code === '1') {
                    Swal.fire(res.status_info, '', 'success')
                    $('#addstatemastersubmit').removeAttr('disabled');
                    load_addstate_data();
                } else {
                    Swal.fire(res.status_info, '', 'error')
                    $('#addstatemastersubmit').removeAttr('disabled');
                }
            }
        });
    }
});
</script>