CREATE table Pr_RecurringMaster
(
    id int not null PRIMARY key AUTO_INCREMENT ,
    name varchar(50) not null,
    freq_Id int not null,
    freq_name varchar(100) not null,
    noofmonths int not null DEFAULT 0,
    noofdays	int not null DEFAULT 0,
    recu_days int not null DEFAULT 0,
    no_recu int not null DEFAULT 4,
    validfrom DATETIME DEFAULT CURRENT_TIMESTAMP,
    validto DATETIME null default null,
    practice int ,
    subpractice int ,
    activity int not null,
    subactivity varchar(100),
    staff_id varchar(100),
    specific_date varchar(25),
    created_by varchar(100),
    created_date DATETIME DEFAULT   CURRENT_TIMESTAMP,
    updated_by varchar(100),
    updated_time DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    isactive BOOLEAN DEFAULT false,
    status int not null
)

create table recuMaster_assign
(
    id int not null PRIMARY key AUTO_INCREMENT,
    recu_masterId int not null,
    client_ids varchar(100) not null,
    location_bsd varchar(250) not null,
    turnover_bsd varchar(250) not null,
    remarks varchar(500) not null,
    instruction varchar(500) not null,
    status int not null
)

create table new_master_recurring
(
    id int not null PRIMARY key AUTO_INCREMENT,
    practice_id int not null,
    sub_practice_id int not null,
    activity_id int not null,
    location_id int not null,
    turnover_id int not null,
    recu_freq int not null,
    recu_type varchar(25) not null, -- eg :- yearly,monthly    
    task_date int not null, -- eg:- no of days before target date,
    effect_from varchar(25),
    effect_to varchar(25),
    sub_activity varchar(250),
    remarks varchar(500),
    notes varchar(500),
    status int not null
)

create table  recu_yearly(
	id int not null  PRIMARY key AUTO_INCREMENT,
    master_id int not null,
    month int not null DEFAULT 0,
    date int not null,
    created_by varchar(50),
    created_date datetime DEFAULT CURRENT_DATE,
    updated_by varchar(50),
    updated_date datetime DEFAULT CURRENT_TIMESTAMP on UPDATE CURRENT_TIMESTAMP,
    status int not null,
    FOREIGN KEY (master_id) REFERENCES new_master_recurring (id) ON DELETE CASCADE
)

create table  recu_quarterly(
	id int not null  PRIMARY key AUTO_INCREMENT,
    master_id int not null,
    compliance varchar(100) not null,
    Compliance_date int,
    q1_month int,
    q2_month int,
    q3_month int,
    q4_month int,
    q1_days int,
    q2_days int,
    q3_days int,
    q4_days int,
    created_by varchar(50),
    created_date datetime DEFAULT CURRENT_DATE,
    updated_by varchar(50),
    updated_date datetime DEFAULT CURRENT_TIMESTAMP on UPDATE CURRENT_TIMESTAMP,
    status int not null,
    FOREIGN KEY (master_id) REFERENCES new_master_recurring (id) ON DELETE CASCADE
)

create table  recu_monthly(
	id int not null  PRIMARY key AUTO_INCREMENT,
    master_id int not null,    
    date int not null,
    created_by varchar(50),
    created_date datetime DEFAULT CURRENT_DATE,
    updated_by varchar(50),
    updated_date datetime DEFAULT CURRENT_TIMESTAMP on UPDATE CURRENT_TIMESTAMP,
    status int not null,
    FOREIGN KEY (master_id) REFERENCES new_master_recurring (id) ON DELETE CASCADE
)

create table  recu_weekly(
	id int not null  PRIMARY key AUTO_INCREMENT,
    master_id int not null,    
    day varchar(25) not null,
    created_by varchar(50),
    created_date datetime DEFAULT CURRENT_TIMESTAMP,
    updated_by varchar(50),
    updated_date datetime DEFAULT CURRENT_TIMESTAMP on UPDATE CURRENT_TIMESTAMP,
    status int not null,
    FOREIGN KEY (master_id) REFERENCES new_master_recurring (id) ON DELETE CASCADE
)

create TABLE turnoverMaster (
    id int not null PRIMARY key AUTO_INCREMENT,
    turnover varchar(1000) not null,
    created_by varchar(25),
    created_date TIMESTAMP  not null DEFAULT CURRENT_TIMESTAMP,
    updated_by varchar(25),
    updated_date TIMESTAMP  not null DEFAULT CURRENT_TIMESTAMP on UPDATE CURRENT_TIMESTAMP,
    status int not null
)
    
select d.activity_name,a.recu_type,e.form_no+' '+e.state_group as loc ,a.effect_from,a.effect_to  from new_master_recurring a
inner join practice_area b on a.practice_id = b.practice_id
inner join sub_practice_area c on a.sub_practice_id = c.sub_practice_id
inner join activity_table  d on a.activity_id = d.activity_id
left join recu_state_group e on a.location_id = e.id and a.location_id > 0
left join turnovermaster f on a.turnover_id = f.id and a.turnover_id > 0
where a.status = '1'

select distinct d.activity_name,a.recu_type,e.form_no+' '+e.state_group as loc ,f.turnover,a.effect_from,a.effect_to  from new_master_recurring a
inner join practice_area b on a.practice_id = b.practice_id
inner join sub_practice_area c on a.sub_practice_id = c.sub_practice_id
inner join activity_table  d on a.activity_id = d.activity_id
left join recu_state_group e on a.location_id = e.id and a.location_id > 0
left join turnovermaster f on a.turnover_id = f.id and a.turnover_id > 0
where a.status = '1'