<?php
error_reporting(E_ERROR | E_PARSE);
session_start();
require '../../Class/ClassForm.php';
include 'master_data.php';
date_default_timezone_set('asia/kolkata');
$dt = new DateTime();
if(isset($_POST)){
    extract($_POST);        
    $MasterEntry = array(
        id => 0,
        practice_id => $practice_id,
        sub_practice_id => $sub_practice_id,
        activity_id => $activity_id,
        location_id => $AssignLoc_Based,
        turnover_id => $AssignTOV_Based,
        recu_freq => $recurring_frequency,
        recu_type => $frequency[$recurring_frequency], // eg :- yearly,monthly    
        task_date => $recu_days, // eg:- no of days before target date,
        effect_from => $validfrom,
        effect_to => $validto,
        sub_activity => implode(',',$sub_activity_id),
        remarks => $YearOption,
        notes => '',
        status => 1
    );   
    $status = $ClassForm->f_mysql_insert_array('new_master_recurring', $MasterEntry);
    if ($status['mysqli_error'] == false){
        $masterId = $status['mysqli_insert_id'];
        if($masterId > 0){
            $switch = $frequency[$recurring_frequency];            
            switch($switch){
                case 'yearly':                    
                    $yearEntry = array(
                        id => 0,
                        master_id => $masterId,
                        month => $yearMonth,
                        date => $yearlyDay,
                        created_by => $_SESSION['SESS_MEMBER_ID'],
                        created_date => $dt->format('Y-m-d H:i:s'),
                        updated_by => $_SESSION['SESS_MEMBER_ID'],  
                        updated_date => $dt->format('Y-m-d H:i:s'),
                        status => 1,
                    );
                    $Yearstatus = $ClassForm->f_mysql_insert_array('recu_yearly', $yearEntry);                    
                    if($Yearstatus['mysqli_error'] != false){
                        $return_array = array(
                            'status' => '0',
                            'status_info' => 'Unable to Add Recurring Task. Please contact support team.'
                        );
                        echo $jsonformat = json_encode($return_array);
                        exit;
                    }
                break;
                case 'quarterly':
                    $quarterlyEntry = array(
                        id => 0,
                        master_id => $masterId,
                        compliance => $switchCompliance,
                        Compliance_date => $QuaterComplicanceDays,
                        q1_month => $QuaterSpecifiedMonthQ1,
                        q2_month => $QuaterSpecifiedMonthQ2,
                        q3_month => $QuaterSpecifiedMonthQ3,
                        q4_month => $QuaterSpecifiedMonthQ4,
                        q1_days => $QuaterSpecifiedDaysQ1 == '' ? 0 : $QuaterSpecifiedDaysQ1,
                        q2_days => $QuaterSpecifiedDaysQ2 == '' ? 0 : $QuaterSpecifiedDaysQ2,
                        q3_days => $QuaterSpecifiedDaysQ3 == '' ? 0 : $QuaterSpecifiedDaysQ3,
                        q4_days => $QuaterSpecifiedDaysQ4 == '' ? 0 : $QuaterSpecifiedDaysQ4,
                        created_by => $_SESSION['SESS_MEMBER_ID'],
                        created_date => $dt->format('Y-m-d H:i:s'),
                        updated_by => $_SESSION['SESS_MEMBER_ID'],                                               
                        status => 1,
                    );                    
                    $quarterlystatus = $ClassForm->f_mysql_insert_array('recu_quarterly', $quarterlyEntry);
                    if($quarterlystatus['mysqli_error'] != false){
                        $return_array = array(
                            'status' => '0',
                            'status_info' => 'Unable to Add Recurring Task. Please contact support team.'
                        );
                        echo $jsonformat = json_encode($return_array);
                        exit;
                    }
                break;
                case 'monthly':
                    $monthlyEntry = array(
                        id => 0,
                        master_id => $masterId,                       
                        date => $monthlyDay,
                        created_by => $_SESSION['SESS_MEMBER_ID'],
                        created_date => $dt->format('Y-m-d H:i:s'),
                        updated_by => $_SESSION['SESS_MEMBER_ID'],                        
                        status => 1,
                    );
                    $monthlystatus = $ClassForm->f_mysql_insert_array('recu_monthly', $monthlyEntry);
                    if($monthlystatus['mysqli_error'] != false){
                        $return_array = array(
                            'status' => '0',
                            'status_info' => 'Unable to Add Recurring Task. Please contact support team.'
                        );
                        echo $jsonformat = json_encode($return_array);
                        exit;
                    }
                break;
                case 'weekly':
                    $weeklyEntry = array(
                        id => 0,
                        master_id => $masterId,                       
                        day => $weeklyDay,
                        created_by => $_SESSION['SESS_MEMBER_ID'],
                        created_date => $dt->format('Y-m-d H:i:s'),
                        updated_by=> $_SESSION['SESS_MEMBER_ID'],                        
                        status => 1,
                    );
                    $weeklystatus = $ClassForm->f_mysql_insert_array('recu_weekly', $weeklyEntry);
                    if($weeklystatus['mysqli_error'] != false){
                        $return_array = array(
                            'status' => '0',
                            'status_info' => 'Unable to Add Recurring Task. Please contact support team.'
                        );
                        echo $jsonformat = json_encode($return_array);
                        exit;
                    }
                break;
            }
            $return_array = array(
                'status' => '1',
                'status_code' => $masterId,
                'status_info' => 'Recurring Task Added Successfully'
            );
            echo $jsonformat = json_encode($return_array);
            exit;
        }
        else{
            $return_array = array(
                'status' => '0',
                'status_info' => 'Unable to Add Recurring Task. Please contact support team.'
            );
            echo $jsonformat = json_encode($return_array);
            exit;
        }
        
    }
    else{
        $return_array = array(
            'status' => '0',
            'status_info' => 'Unable to Add Recurring Task. Please contact support team.'
        );
        echo $jsonformat = json_encode($return_array);
        exit;
    }
}
?>