<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.6.1/dist/sweetalert2.all.min.js"></script>
<?php

require '../../Class/OfficeClassDet.php';
$category = $OfficeClassDet->get_Service_Category_Details();

?>
  <table id="categorytable" class="table table-responsive table-condensed table-striped table-bordered" border="1" style="border-collapse: collapse; border: 1px solid #000" >
                                        <thead>
                                            <tr>
                                                <th>Service Name</th>
                                                <th>Service ShortName</th>
                                                <th>Service Code</th>
                                                <th>Status</th>
                                                <th>option</th>
                                                <th>Action</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php while ($arr = mysqli_fetch_assoc($category)) {
                                                ?>
                                                <tr>
                                                    <td><?php echo $arr['service_name']; ?></td>
                                                    <td><?php echo $arr['service_short'] ?></td>
                                                    <td><?php echo $arr['created_by'] ?></td>

                                                    <td>
                                                        <?php
                                                        if ($arr['status'] === '1') {
                                                            echo '<a class="btn btn-metis-2 btn-sm btn-circle btn-grad" href="#" data-original-title="" title="">A</a>';
                                                        } else if ($arr['status'] === '2') {
                                                            echo '<a class="btn btn-metis-1 btn-sm btn-circle btn-grad" href="#" data-original-title="" title="">D</a>';
                                                        } else if ($arr['status'] === '0') {
                                                            echo '<a class="btn btn-warning btn-sm btn-circle btn-grad" href="#" data-original-title="" title="">IA</a>';
                                                        }
                                                        ?>
                                                    </td>                            
                                                    <td>
                                                        <select class="form-control" id="<?php echo 'status_' . $arr['service_id']; ?>" name="<?php echo 'status_' . $arr['service_id']; ?>">
                                                            <option value="">Select</option>
                                                            <?php if ($arr['status'] === '1') { ?>
                                                                <option value="2">Delete</option>
                                                                <option value="0">In Activate</option> 
                                                            <?php } ?>
                                                            <?php if ($arr['status'] === '0') { ?>
                                                                <option value="1">Activate</option>
                                                                <option value="2">Delete</option>                                   
                                                            <?php } ?>
                                                            <?php if ($arr['status'] === '2') { ?>
                                                                <option value="1">Activate</option>
                                                                <option value="0">In Activate</option> 
                                                                <option value="2">Delete </option> 
                                                            <?php } ?>
                                                        </select>
                                                    </td>
                                                    <td><a class="btn btn-metis-4" href="javascript:service_status_action('<?php echo $arr['service_id']; ?>')" data-original-title="" title="">Go</a></td>
                                                    <td <?php
                                                    if ($arr['status'] != '1') {
                                                        echo 'style="text-align:center;"';
                                                    }
                                                    ?>>  <?php
                                                            if ($arr['status'] != '1') {
                                                                echo '<span>-</span>';
                                                            } else {
                                                                ?>
                                                            <a class="btn btn-primary" href="javascript:edit_categorydetails('<?php echo $arr['service_id']; ?>')" data-original-title="" title="">Edit</a>
                                                        <?php } ?></td>

                                                </tr>
                                            <?php } ?>                                        
                                        </tbody>
                                    </table>
  <script>
var $ = jQuery.noConflict();
var prTable = $('#categorytable').DataTable({
    bAutoWidth: false,
    "aoColumns": [
        null,
        null,
        null,
        null,
        null,
        null,

        {
            "bSortable": false
        }
    ],
    "aaSorting": [],
    select: {
        style: 'multi'
    }
});
$.fn.dataTable.Buttons.defaults.dom.container.className = 'dt-buttons btn-overlap btn-group btn-overlap';
new $.fn.dataTable.Buttons(prTable, {
    buttons: [{
            "extend": "colvis",
            "text": "<i class='fa fa-search bigger-110 blue'></i> <span class='hidden'>Show/hide columns</span>",
            "className": "btn btn-white btn-primary btn-bold",
            columns: ':not(:first):not(:last)'
        },
        {
            "extend": "copy",
            "text": "<i class='fa fa-copy bigger-110 pink'></i> <span class='hidden'>Copy to clipboard</span>",
            "className": "btn btn-white btn-primary btn-bold"
        },
        {
            "extend": "csv",
            "text": "<i class='fa fa-database bigger-110 orange'></i> <span class='hidden'>Export to CSV</span>",
            "className": "btn btn-white btn-primary btn-bold"
        },
        {
            "extend": "excel",
            "text": "<i class='fa fa-file-excel-o bigger-110 green'></i> <span class='hidden'>Export to Excel</span>",
            "className": "btn btn-white btn-primary btn-bold"
        },
        {
            "extend": "pdf",
            "text": "<i class='fa fa-file-pdf-o bigger-110 red'></i> <span class='hidden'>Export to PDF</span>",
            "className": "btn btn-white btn-primary btn-bold"
        },
        {
            "extend": "print",
            "text": "<i class='fa fa-print bigger-110 grey'></i> <span class='hidden'>Print</span>",
            "className": "btn btn-white btn-primary btn-bold",
            message: 'LMS - SW Report Printout'
        }
    ]
});
prTable.buttons().container().appendTo($('.tableTools-container'));
var defaultCopyAction = prTable.button(1).action();
prTable.button(1).action(function(e, dt, button, config) {
    defaultCopyAction(e, dt, button, config);
    $('.dt-button-info').addClass('gritter-item-wrapper gritter-info gritter-center white');
});
var defaultColvisAction = prTable.button(0).action();
prTable.button(0).action(function(e, dt, button, config) {
    defaultColvisAction(e, dt, button, config);
    if ($('.dt-button-collection > .dropdown-menu').length == 0) {
        $('.dt-button-collection')
            .wrapInner('<ul class="dropdown-menu dropdown-light dropdown-caret dropdown-caret" />')
            .find('a').attr('href', '#').wrap("<li />")
    }
    $('.dt-button-collection').appendTo('.tableTools-container .dt-buttons')
});

function service_status_action(service_id) {
    var status_id = $('#status_' + service_id + '').val();
    if (status_id == "1") {
                    msg = "Are you sure want to Activate ?";
                } else if (status_id == "3") {
                    msg = "Are you sure want to Delete ?";
                }
                else {
                    msg = "Are you sure want to In Activate ?";
                }

    if (status_id) {
        Swal.fire({
                                title: msg,
                                showCancelButton: true,
                                confirmButtonText: `Yes`,

                            }).then((result) => {

                                if (result.isConfirmed) {
                                    $.ajax({
                                        type: "POST",
                                        url: "PHP/Office_mgn/lms_sb_editstatus_category.php",
                                        data: {service_id: service_id, status_id: status_id},
                                        dataType: "json",
                                        success: function(res) {
                                            if (res.status_code === '1') {
                                                Swal.fire(res.status_info, '', 'success')
                                                load_service_data();
                                            } else {
                                                Swal.fire(res.status_info, '', 'error')
                                            }
                                        }
                                    });

                                }
                            }) 
           } else {
        Swal.fire({
                     icon: 'warning',
                     text: 'Please Select Options',
                 })
    }
}

function edit_categorydetails(service_id) {
   // console.log(service_id);
    $.ajax({
        type: "POST",
        url: "PHP/Office_mgn/lms_sb_editcategory_office.php",
        data: {service_id: service_id},
        dataType: "html",
        success: function (result)
        {
            $('.viewcategoryDiv').html(result);

        }
    });
}

</script>

