<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.6.1/dist/sweetalert2.all.min.js"></script>

<form enctype="multipart/form-data" class="form-horizontal" method="post" id="notification_panel"
    name="notification_panel" action="javascript:;">

    <input type="hidden" id="rectype" name="rectype" value="" />

    <div class="panel panel-flat">

        <div class="panel-heading" style="text-align:center;">

            <h3 class="panel-title">Create Notification</h3>

            <a class="heading-elements-toggle"><i class="icon-menu"></i></a>
        </div>

        <div class="panel-body">

            <div class="form-group">

                <label class="col-lg-3 control-label">Receiver Type</label>

                <div class="col-lg-3">

                    <label class="radio-inline">

                        <input type="radio" class="styled" name="receiver_type" value="individual"
                            onclick="show_team_list(this);" value="individual" checked="checked">

                        Individual

                    </label>



                    <label class="radio-inline">

                        <input type="radio" class="styled" value="team" onclick="show_team_list(this);"
                            name="receiver_type">

                        Entire Team

                    </label>

                </div>

            </div>



            <div class="form-group" id="user_list_selection">

                <label class="control-label col-lg-3">Choose Receiver<em class="required">&nbsp;*</em></label>

                <div class="col-lg-3">

                    <input type="text" class="searchUsers form-control" width="100%" height="100%"
                        placeholder="search user list" />

                    <select multiple="" class="form-control" id="user_unselect" size="5">
                    </select>
                </div>

                <div class="col-lg-1">

                    <div class="controls">

                        <a href="javascript:DualSelct('user_unselect', 'user_select')" class="btn btn-warning">&gt;</a> </br>
</br>
                        <a href="javascript:DualSelct('user_select', 'user_unselect')" class="btn btn-warning">&lt;</a> </br>

                    </div>

                </div>

                <div class="col-lg-3">

                    <select class="form-control" multiple="" id="user_select" size="7" name="user_selected[]"></select>

                </div>

            </div>



            <div class="form-group">

                <label class="col-lg-3 control-label">Notification Type:</label>

                <div class="col-lg-3">

                    <label class="radio-inline">

                        <input type="radio" class="styled" value="immediate" onclick="show_controller(this);"
                            name="notification_type" checked="checked">

                        Immediate

                    </label>

                </div>

            </div>

            <div class="form-group" id="date_range_sel" style="display:none">

                <div class="form-group">

                    <label class="col-lg-3 control-label">Date Range</label>

                    <div class="col-lg-9">

                        <input type="text" class="form-control daterange-basic" id="notification_date_range"
                            name="notification_date_range" placeholder="Try me&hellip;">

                    </div>

                </div>

            </div>



            <div class="form-group" id="day_of_week" style="display:none">

                <label class="col-lg-3 control-label">Day of Week</label>

                <div class="col-lg-9">

                    <select class="form-control select" name="day_of_week_notify" id="day_of_week_notify" size="5">

                        <option value="0">Sunday</option>

                        <option value="1">Monday</option>

                        <option value="2">Tuesday</option>

                        <option value="3">Wednesday</option>

                        <option value="4">Thursday</option>

                        <option value="5">Friday</option>

                        <option value="6">Saturday</option>

                    </select>

                </div>

            </div>



            <div class="form-group" id="send_time" style="display:none">

                <label class="col-lg-3 control-label">Send Time</label>

                <div class="col-lg-9">

                    <input type="text" class="form-control form-control pickatime picker__input" name="send_time_notify"
                        id="send_time_notify" placeholder="Try me&hellip;">

                </div>

            </div>







            <div class="form-group">

                <label class="col-lg-3 control-label">Your message:<em class="required">&nbsp;*</em></label>

                <div class="col-lg-9">

                    <textarea rows="5" cols="5" class="form-control" name="notification_message"
                        id="notification_message" placeholder="Enter your message here"></textarea>

                </div>

            </div>



            <div class="form-group">

                <label class="col-lg-3 control-label">Read Receipt</label>

                <div class="col-lg-3">

                    <label class="radio-inline">

                        <input type="radio" class="styled" value="0" name="read_receipt" checked="checked" disabled>

                        No

                    </label>



                    <label class="radio-inline">

                        <input type="radio" class="styled" value="1" name="read_receipt" disabled>

                        Yes

                    </label>

                </div>

            </div>



            <div class="text-right">

                <button type="submit" id="notification_submit" class="button btn-primary">Submit form <i
                        class="icon-arrow-right14 position-right"></i></button>

            </div>

        </div>

    </div>

</form>

<script>
$(document).ready(function() {
    $('#rectype').val('individual');
    load_user_list();
})

function show_team_list(element) {
    var checked = $(element).val();
    if (checked === 'individual') {
        $('#rectype').val('individual');
        $("#user_list_selection").show();
    } else {
        $('#rectype').val('team');
        $("#user_list_selection").hide();
    }
}

function show_controller(element)

{

    var checked = $(element).val();

    if (checked === 'immediate')

    {
        $("#date_range_sel").hide();
        $("#day_of_week").hide();
        $("#send_time").hide();

    } else if (checked === 'daily')

    {
        $("#date_range_sel").hide();
        $("#day_of_week").hide();
        $("#send_time").show();

    } else if (checked === 'weekly')

    {
        $("#date_range_sel").hide();
        $("#day_of_week").show();
        $("#send_time").show();

    } else if (checked === 'date_range')

    {
        $("#date_range_sel").show();
        $("#day_of_week").hide();
        $("#send_time").show();
    }



}

function DualSelct(from, to) {
    $('#' + from + ' option:selected').remove().appendTo('#' + to);
    $('#user_select').find('option').each(function() {
        $(this).attr("selected", "selected")
    });

}

function load_user_list()

{
    $.ajax({
        type: "POST",
        url: "PHP/Notification/load_user_list.php",
        success: function(response) {
            $('#user_unselect').html(response);
            $('#user_unselect').filterPrabhu($('.searchUsers'));

        }
    });
}

function submitvalidationchk() {
    var userlist = $('#user_select').val();
    var msg = $('#notification_message').val();
    var receivetype = $('#rectype').val();

    if (((userlist == "") || (userlist == null)) && (receivetype == "individual")) {
        Swal.fire({
            icon: 'error',
            text: 'Please select userlist',
        })
    } else if (msg == "") {
        Swal.fire({
            icon: 'error',
            text: 'Please Enter Message',
        })
    } else {
        return true;
    }
}


$("#notification_panel").on("submit", function(event) {

    event.preventDefault();
    if (submitvalidationchk()) {
        $('#user_select').find('option').each(function() {
            $(this).attr("selected", "selected")
        });

        var formData = new FormData($('#notification_panel')[0]);
        var user_selected = $('#user_select option').map(function() {
            return this.value
        }).get();

        formData.append('user_selected', user_selected);

        $.ajax({

            url: "PHP/Notification/save_notification.php",
            type: "POST",
            dataType: "JSON",
            data: formData,
            contentType: false,
            processData: false,
            success: function(response) {
                if (response.status === '1') {
                    setTimeout(function() {
                        NotificationMail(formData);
                        Swal.fire('Notification has been created successfully', '',
                            'success')
                            Load_New_ntfy();
                    }, 1000);
                } else if (response.status === '0') {
                    Swal.fire('Internal Server Error.Unable to Create Notification.', '', 'error')
                }
               
            }
        });
    }
});

function NotificationMail(formData) {

    $.ajax({

        url: "PHP/Notification/mail_notification.php",
        type: "POST",
        dataType: "JSON",
        data: formData,
        contentType: false,
        processData: false,
        success: function(response) {

        }
    });
}
jQuery.fn.filterPrabhu = function(textbox) {

return this.each(function() {

    var select = this;

    var options = [];

    $(select).find('option').each(function() {

        options.push({

            value: $(this).val(),

            text: $(this).text()

        });

    });

    $(select).data('options', options);



    $(textbox).bind('change keyup', function() {

        var options = $(select).empty().data('options');

        var search = $.trim($(this).val());

        var regex = new RegExp(search, "gi");



        $.each(options, function(i) {

            var option = options[i];

            if (option.text.match(regex) !== null) {

                $(select).append(

                    $('<option>').text(option.text).val(option.value)

                );

            }

        });

    });

});

};
$('#user_unselect').filterPrabhu($('.searchUsers'));
</script>