<?php

class product_class {

    protected $conn;

    public function __construct() {
        $this->DbConnect();
    }

    protected function DbConnect() {
        include "dbconfig.php";
        date_default_timezone_set('Asia/Kolkata');
        $this->conn = mysqli_connect($host, $user, $password) OR die("Unable to connect to the database");
        mysqli_select_db( $this->conn,$db) OR die("can not select the database $db");
        return TRUE;
    }

    public function clean($str) {
        $str = @trim($str);
        if (get_magic_quotes_gpc()) {
            $str = stripslashes($str);
        }
        return mysqli_real_escape_string($str);
    }

    ######################## 
    # General function to insert associative arry to table
    # Modified : Nagarajan   Version:1.0
    # Date: 16/Feb/2015

    function f_mysql_insert_array($table, $data, $exclude = array()) {
        $fields = $values = array();
        if (!is_array($exclude))
            $exclude = array($exclude);
        foreach (array_keys($data) as $key) {
            if (!in_array($key, $exclude)) {
                $fields[] = "`$key`";
                $values[] = "'" . mysqli_real_escape_string($data[$key]) . "'";
            }
        }
        $fields = implode(",", $fields);
        $values = implode(",", $values);
        if (mysqli_query("INSERT INTO `$table` ($fields) VALUES ($values)")) {
            return array("mysqli_error" => false,
                "mysqli_insert_id" => mysqli_insert_id(),
                "mysqli_affected_rows" => mysqli_affected_rows(),
                "mysqli_info" => mysqli_info()
            );
        } else {
            return array("mysqli_error" => mysqli_error());
        }
    }
    
    function check_product_duplicate($product_name)
    {
        //$sql = "SELECT count(app_id) num_count FROM application_details WHERE LOWER(TRIM(customer_name))=LOWER(TRIM('$customer_name')) AND app_type='$app_type' AND status='1'";
      $sql = "SELECT EXISTS(SELECT 1 FROM product_category WHERE LOWER(TRIM(prd_category_name))=LOWER(TRIM('$product_name')) AND status ='1') AS flag";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['flag'];
    
    }
    
     function load_products_db() {
        $sql = "SELECT * FROM product_category WHERE status !='3'";
        $result = mysqli_query($sql);
        return $result;
    }
     function update_products_db($prd_category_id, $action_val) {
        $sql = "UPDATE product_category SET status='$action_val' WHERE prd_category_id='$prd_category_id'";
        $result = mysqli_query($sql);
        return $result;
    }
//========================================================================================//
    public function Function_Update_SQL($array, $table, $condition) {

        if (count($array) > 0) {
            foreach ($array as $key => $value) {

                $value = mysqli_real_escape_string($value); // this is dedicated to @Jon
                $value = "'$value'";
                $updates[] = "$key = $value";
            }
        }
        $implodeArray = implode(', ', $updates);
        $sql = ("UPDATE $table SET $implodeArray WHERE $condition");
        $result = mysqli_query($sql);
        return $result;
    }

    function Check_Login($Username, $Password) {
        $sql = "SELECT * FROM app_user WHERE LOWER(TRIM(user_login_id))=LOWER(TRIM('$Username')) AND user_pwd='$Password'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array;
    }

    function Check_Customer_Exisist($customer_name, $app_type) {
        $sql = "SELECT count(app_id) num_count FROM application_details WHERE LOWER(TRIM(customer_name))=LOWER(TRIM('$customer_name')) AND app_type='$app_type' AND status='1'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['num_count'];
    }
    

    function Check_Customer_Exisist_Update($customer_name, $app_type, $app_id) {
        $sql = "SELECT count(app_id) num_count FROM application_details WHERE LOWER(TRIM(customer_name))=LOWER(TRIM('$customer_name')) AND app_type='$app_type' AND status='1' AND app_id !='$app_id'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['num_count'];
    }

    function GetAvailable_Apps() {
        $sql = "SELECT * FROM application_details WHERE status !='3'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Update_Application_Action($app_id, $action_val) {
        $sql = "UPDATE application_details SET status='$action_val' WHERE app_id='$app_id'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Get_Application_Details($app_id) {
        $sql = "SELECT * FROM application_details WHERE status !='3' AND app_id='$app_id'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array;
    }

    function Get_Image_Path($app_id) {
        $sql = "SELECT customer_logo_img,customer_header_logo FROM application_details WHERE app_id='$app_id'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array;
    }

    function GetAvailable_Apps_Role($application_type) {
        $sql = "SELECT * FROM application_details WHERE status !='3' AND app_type='$application_type'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Check_Role_Exisist($application_type, $app_id, $role_name) {
        $sql = "SELECT count(app_id) num_count FROM app_role WHERE LOWER(TRIM(role_name))=LOWER(TRIM('$role_name')) AND app_type='$application_type' AND app_id ='$app_id' AND status='1'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['num_count'];
    }

    function GetAvailable_Role() {
        $sql = "SELECT * FROM app_role WHERE status !='3'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Get_Customer_Name($app_id) {
        $sql = "SELECT customer_name FROM application_details WHERE app_id ='$app_id'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['customer_name'];
    }

    function Update_Role_Action($app_id, $action_val) {
        $sql = "UPDATE app_role SET status='$action_val' WHERE role_id='$app_id'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Get_Role_Details($role_id) {
        $sql = "SELECT * FROM app_role WHERE status !='3' AND role_id='$role_id'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array;
    }

    function Check_Role_Exisist_Update($app_id, $application_type, $role_name, $role_id) {
        $sql = "SELECT count(app_id) num_count FROM app_role WHERE LOWER(TRIM(role_name))=LOWER(TRIM('$role_name')) AND app_type='$application_type' AND app_id ='$app_id' AND role_id !='$role_id' AND status !='3'";
        $result = mysqil_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['num_count'];
    }

    function Check_User_Exisist($app_id, $user_name, $email) {
        $sql = "SELECT count(app_id) num_count FROM app_user WHERE LOWER(TRIM(user_name))=LOWER(TRIM('$user_name')) AND LOWER(TRIM(user_email))=LOWER(TRIM('$email')) AND app_id ='$app_id' AND status !='3'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['num_count'];
    }

    function Check_User_Exisist_Update($app_id, $user_name, $email, $user_id) {
        $sql = "SELECT count(app_id) num_count FROM app_user WHERE LOWER(TRIM(user_name))=LOWER(TRIM('$user_name')) AND LOWER(TRIM(user_email))=LOWER(TRIM('$email')) AND app_id ='$app_id' AND user_id !='$user_id' AND status !='3'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['num_count'];
    }

    function Create_Login($user_name) {
        $login_id = '';
        $user_name_orig = $user_name;

        for ($i = 1; $i <= 11; $i++) {
            $sql = "SELECT count(app_id) num_count FROM app_user WHERE LOWER(TRIM(user_login_id))=LOWER(TRIM('$user_name'))";
            $result = mysqli_query($sql);
            $array = mysqlifetch_assoc($result);
            if ($array['num_count'] == 0) {
                $login_id = $user_name;
                break;
            } else {
                $user_name = $user_name_orig . '_' . $i;
            }
        }

        return $login_id;
    }

    function GetAvailable_User($app_id) {
        $sql = "SELECT * FROM app_user WHERE status !='3' AND app_id='$app_id'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Update_User_Action($user_id, $action_val) {
        $sql = "UPDATE app_user SET status='$action_val' WHERE user_id='$user_id'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Get_User_Details($user_id) {
        $sql = "SELECT * FROM app_user WHERE status !='3' AND user_id='$user_id'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array;
    }

    function Check_Reource_Exisist($resource_name, $resource_action, $resource_url) {
        $sql = "SELECT count(app_id) num_count FROM app_resource WHERE LOWER(TRIM(resource_name))=LOWER(TRIM('$resource_name')) AND LOWER(TRIM(resource_action))=LOWER(TRIM('$resource_action')) AND LOWER(TRIM(resource_url))=LOWER(TRIM('$resource_url')) AND status !='3'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['num_count'];
    }

    function Check_Reource_Exisist_update($resource_name, $resource_action, $resource_url, $resource_id) {
        $sql = "SELECT count(app_id) num_count FROM app_resource WHERE LOWER(TRIM(resource_name))=LOWER(TRIM('$resource_name')) AND LOWER(TRIM(resource_action))=LOWER(TRIM('$resource_action')) AND LOWER(TRIM(resource_url))=LOWER(TRIM('$resource_url')) AND resource_id !='$resource_id' AND status !='3'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['num_count'];
    }

    function GetAvailable_Resource() {
        $sql = "SELECT * FROM app_resource WHERE status !='3'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Update_Resource_Action($resource_id, $action_val) {
        $sql = "UPDATE app_resource SET status='$action_val' WHERE resource_id='$resource_id'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Get_Resource_Details($resource_id) {
        $sql = "SELECT * FROM app_resource WHERE status !='3' AND resource_id='$resource_id'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array;
    }

    function Get_Apps_Role($app_id) {
        $sql = "SELECT * FROM app_role WHERE status !='3' AND app_id='$app_id'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Get_Assigned_User($app_id, $role_id) {
        $sql = "SELECT user_id FROM role_user WHERE status !='3' AND app_id='$app_id' AND role_id='$role_id'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Get_User_Id($user_id) {
        $sql = "SELECT user_login_id FROM app_user WHERE status !='3' AND user_id='$user_id'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['user_login_id'];
    }

    function Get_unassigned_User($app_id, $role_id) {
        $sql = "SELECT user_id from app_user WHERE user_id NOT IN(SELECT user_id FROM role_user WHERE status !='3' AND app_id='$app_id') AND app_id='$app_id'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Update_user_role($app_id, $role_id, $user_id_array) {
        $sql = "DELETE FROM role_user WHERE app_id='$app_id' AND role_id='$role_id'";
        $result = mysqli_query($sql);
        if ($result) {
            $user_id_val = explode(',', $user_id_array);
            $dt = new DateTime();
            for ($i = 0; $i < count($user_id_val); $i++) {
                $entry = array(
                    'role_user_id' => 0,
                    'app_id' => $app_id,
                    'role_id' => $role_id,
                    'user_id' => $user_id_val[$i],
                    'created_by' => $_SESSION['SESS_MEMBER_USER_NAME'],
                    'created_date' => $dt->format('Y-m-d H:i:s'),
                    'updated_by' => $_SESSION['SESS_MEMBER_USER_NAME'],
                    'status' => '1'
                );
                $status = $this->f_mysql_insert_array('role_user', $entry);
            }
            if (!$status['mysqli_error']) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    function GetAssigned_Resource($role_id, $app_id) {
        $sql = "SELECT resource_id FROM role_resource WHERE status !='3' AND app_id='$app_id' AND role_id='$role_id'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Update_role_resource($app_id, $role_id, $resource_id_array) {
        $sql = "DELETE FROM role_resource WHERE app_id='$app_id' AND role_id='$role_id'";
        $result = mysqli_query($sql);
        if ($result) {
            $resource_id_val = explode(',', $resource_id_array);
            $dt = new DateTime();
            for ($i = 0; $i < count($resource_id_val); $i++) {
                $entry = array(
                    'role_resource_id' => 0,
                    'app_id' => $app_id,
                    'role_id' => $role_id,
                    'resource_id' => $resource_id_val[$i],
                    'created_by' => $_SESSION['SESS_MEMBER_USER_NAME'],
                    'created_date' => $dt->format('Y-m-d H:i:s'),
                    'updated_by' => $_SESSION['SESS_MEMBER_USER_NAME'],
                    'status' => '1'
                );
                $status = $this->f_mysql_insert_array('role_resource', $entry);
            }
            if (!$status['mysqli_error']) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    function load_controller_resource($app_id, $role_id) {
        $sql = "SELECT * FROM role_resource WHERE (status ='1' AND app_id='$app_id' AND role_id='$role_id')";
        $result = mysqli_query($sql);
        return $result;
    }

    function Get_Reource_Details($resource_id) {
        $sql = "SELECT resource_action,resource_url FROM app_resource WHERE (status ='1' AND resource_id='$resource_id')";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array;
    }
    
    function Get_Common_Resource()
    {
        $sql = "SELECT resource_action,resource_url FROM app_resource WHERE (status ='1' AND common_resource='1')";
        $result = mysqli_query($sql);        
        return $result; 
    }
    
    function Get_Role_id($login_id)
    {
        $sql = "SELECT role_id FROM role_user WHERE user_id =(SELECT user_id FROM app_user WHERE status !='3' AND user_login_id='$login_id')";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['role_id'];
    }

}

$product_class = new product_class();
?>
