<?php

class StaffClassDet {

    protected $conn;

    public function __construct() {
        $this->DbConnect();
    }

    protected function DbConnect() {
        include "dbconfig.php";
        date_default_timezone_set('Asia/Kolkata');
        $this->conn = mysqli_connect($host, $user, $password) OR die("Unable to connect to the database");
        mysqli_select_db($this->conn,$db) OR die("can not select the database $db");
        return TRUE;
    }

    public function clean($str) {
        $str = @trim($str);
        if (get_magic_quotes_gpc()) {
            $str = stripslashes($str);
        }
        return mysqli_real_escape_string($this->conn,$str);
    }

    ######################## 
    # General function to insert associative arry to table
    # Modified : Nagarajan   Version:1.0
    # Date: 16/Feb/2015

    function f_mysql_insert_array($table, $data, $exclude = array()) {
        $fields = $values = array();
        if (!is_array($exclude))
            $exclude = array($exclude);
        foreach (array_keys($data) as $key) {
            if (!in_array($key, $exclude)) {
                $fields[] = "`$key`";
                $values[] = "'" . mysqli_real_escape_string($this->conn,$data[$key]) . "'";
            }
        }
        $fields = implode(",", $fields);
        $values = implode(",", $values);
        if (mysqli_query($this->conn,"INSERT INTO `$table` ($fields) VALUES ($values)")) {
            return array("mysqli_error" => false,
                "mysqli_insert_id" => mysqli_insert_id($this->conn),
                "mysqli_affected_rows" => mysqli_affected_rows(),
                "mysqli_info" => mysqli_info()
            );
        } else {
            return array("mysqlierror" => mysqli_error());
        }
    }

//========================================================================================//
    public function Function_Update_SQL($array, $table, $condition) {

        if (count($array) > 0) {
            foreach ($array as $key => $value) {

                $value = mysqli_real_escape_string($this->conn,$value); // this is dedicated to @Jon
                $value = "'$value'";
                $updates[] = "$key = $value";
            }
        }
        $implodeArray = implode(', ', $updates);
        $sql = ("UPDATE $table SET $implodeArray WHERE $condition");
        $result = mysqli_query($this->conn,$sql);
        return $result;
    }

    public function Common_SQL_Insert($table, $data, $condition, $exclude = array()) {
        $fields = $values = array();
        if (!is_array($exclude))
            $exclude = array($exclude);
        foreach (array_keys($data) as $key) {
            if (!in_array($key, $exclude)) {
                $fields[] = "`$key`";
                $values[] = "'" . mysqli_real_escape_string($this->conn,$data[$key]) . "'";
            }
        }
        $fields = implode(",", $fields);
        $values = implode(",", $values);
        $sql = ("SELECT COUNT(*) as cnt From $table  WHERE $condition");
        $result = mysqli_query($this->conn,$sql);
        $tot_cnt = mysqli_fetch_assoc($result);

        if ($tot_cnt['cnt'] > 0) {
            return array("mysqlierror" => "Already Exist");
        } else {
            if (mysqli_query($this->conn,"INSERT INTO `$table` ($fields) VALUES ($values) ")) {
                return array("mysqli_error" => false,
                    "mysqli_insert_id" => mysqli_insert_id($this->conn),
                    "mysqli_affected_rows" => mysqli_affected_rows(),
                    "mysqli_info" => mysqli_info()
                );
            } else {
                return array("mysqlierror" => mysqli_error());
            }
        }
    }

    public function Common_SQL_update($table, $array, $condition, $existscondition) {

        if (count($array) > 0) {
            foreach ($array as $key => $value) {

                $value = mysqli_real_escape_string($this->conn,$value); // this is dedicated to @Jon
                $value = "'$value'";
                $updates[] = "$key = $value";
            }
        }
        $implodeArray = implode(', ', $updates);
        if ($existscondition != '') {
            $sql = ("SELECT COUNT(*) as cnt From $table  WHERE $existscondition");
            $result = mysqli_query($this->conn,$sql);
            $tot_cnt = mysqli_fetch_assoc($result);

            if ($tot_cnt['cnt'] > 0) {
                return array("mysqli_error" => "Already Exist");
            } else {
                $sql = ("UPDATE $table SET $implodeArray WHERE $condition");
//            echo $sql;exit;
//            $result = mysqliquery($sql);

                if (mysqli_query($this->conn,$sql)) {
                    return array("mysqli_error" => false,
                        "mysqli_affected_rows" => mysqli_affected_rows(),
                        "mysqli_info" => mysqli_info()
                    );
                } else {
                    return array("mysqlierror" => mysqli_error());
                }
            }
        } else {
            $sql = ("UPDATE $table SET $implodeArray WHERE $condition");
//            echo $sql;exit;
//            $result = mysqliquery($sql);

            if (mysqli_query($this->conn,$sql)) {
                return array("mysqli_error" => false,
                    "mysqli_affected_rows" => mysqli_affected_rows(),
                    "mysqli_info" => mysqli_info()
                );
            } else {
                return array("mysqli_error" => mysqli_error());
            }
        }
    }

    function fetch_staff_details($office, $role) {
        $query = "SELECT * FROM office_staff WHERE status!='2' AND staff_type='1'";
        if ($role != '') {
            $query .=" AND staff_role_id = '$role'";
        }
        if ($office != '') {
            $query .=" AND staff_office_id = '$office'";
        }
        $result = mysqli_query($this->conn,$query);
        return $result;
    }

    function fetch_external_staff_details($client_det_grp,$client_det) {
        $query = "SELECT * FROM office_staff WHERE status!='2' AND staff_type='2'";
         if ($client_det_grp != '') {
            $query .=" AND  (FIND_IN_SET('$client_det_grp',client_group_id)> 0)";
        }
        if ($client_det != '') {
            $query .=" AND (FIND_IN_SET('$client_det',external_client_ids) > 0)";
        }
        $result = mysqli_query($this->conn,$query);
        return $result;
    }

    function fetch_staff_role_details($status) {
        $query = "SELECT * FROM system_role WHERE status!='2'";
        if (isset($status) && $status == 1) {
            $query .= " AND status='1'";
        }
        $result = mysqli_query($this->conn,$query);
        return $result;
    }
    
     function fetch_internal_department_details($status) {
        $query = "SELECT * FROM internal_department WHERE status!='2'";
        if (isset($status) && $status == 1) {
            $query .= " AND status='1'";
        }
        $result = mysqli_query($this->conn,$query);
        return $result;
    }

    function fetch_office_details($status) {
        $query = "SELECT * FROM office_details WHERE status!='2'";
        if (isset($status) && $status == 1) {
            $query .= " AND status='1'";
        }
        $result = mysqli_query($this->conn,$query);
        return $result;
    }

    function get_staff_det_by_id($staff_id) {
        $query = "SELECT * FROM office_staff WHERE staff_id ='$staff_id' AND status!='2' AND staff_type='1'";
        $result = mysqli_query($this->conn,$query);
        $data = mysqli_fetch_assoc($result);
        return $data;
    }

    function get_external_staff_det_by_id($staff_id) {
        $query = "SELECT * FROM office_staff WHERE staff_id ='$staff_id' AND status!='2' AND staff_type='2'";
        $result = mysqli_query($this->conn,$query);
        $data = mysqli_fetch_assoc($result);
        return $data;
    }

    function get_sub_practice_det_by_id($subpractice_id) {
        $query = "SELECT * FROM sub_practice_area WHERE sub_practice_id ='$subpractice_id' AND status!='2'";
        $result = mysqli_query($this->conn,$query);
        $data = mysqli_fetch_assoc($result);
        return $data;
    }

    function get_last_staff_details() {

        $query = "SELECT * FROM office_staff Where staff_type='1'ORDER BY staff_id DESC LIMIT 1";
        $result = mysqli_query($this->conn,$query);
        $data = mysqli_fetch_assoc($result);
        return $data;
    }

    function fetch_staff_role_details_id($sid) {
        $query = "SELECT * FROM system_role WHERE role_id='$sid' AND status!='2'";
        $result = mysqli_query($this->conn,$query);
        $data = mysqli_fetch_assoc($result);
        return $data;
    }

}

$StaffClassDet = new StaffClassDet();
?>
