<?php

class OfficeClassDet {

    protected $conn;

    public function __construct() {
        $this->DbConnect();
    }

    protected function DbConnect() {
        include "dbconfig.php";
        date_default_timezone_set('Asia/Kolkata');
        $this->conn = mysqli_connect($host, $user, $password) OR die("Unable to connect to the database");
        mysqli_select_db( $this->conn,$db) OR die("can not select the database $db");
        return TRUE;
    }

    public function clean($str) {
        $str = @trim($str);
        if (get_magic_quotes_gpc()) {
            $str = stripslashes($str);
        }
        return mysqli_real_escape_string($this->conn,$str);
    }

    ######################## 
    # General function to insert associative arry to table
    # Modified : Nagarajan   Version:1.0
    # Date: 16/Feb/2015

    function f_mysql_insert_array($table, $data, $exclude = array()) {
        $fields = $values = array();
        if (!is_array($exclude))
            $exclude = array($exclude);
        foreach (array_keys($data) as $key) {
            if (!in_array($key, $exclude)) {
                $fields[] = "`$key`";
                $values[] = "'" . mysqli_real_escape_string($data[$key]) . "'";
            }
        }
        $fields = implode(",", $fields);
        $values = implode(",", $values);
        if (mysqli_query($this->conn,"INSERT INTO `$table` ($fields) VALUES ($values)")) {
            return array("mysqli_error" => false,
                "mysqli_insert_id" => mysqli_insert_id($this->conn),
                "mysqli_affected_rows" => mysqli_affected_rows($this->conn),
                "mysqli_info" => mysqli_info($this->conn)
            );
        } else {
            return array("mysqli_error" => mysqli_error($this->conn));
        }
    }

//========================================================================================//
    public function Function_Update_SQL($array, $table, $condition) {

        if (count($array) > 0) {
            foreach ($array as $key => $value) {

                $value = mysqli_real_escape_string($this->conn,$value); // this is dedicated to @Jon
                $value = "'$value'";
                $updates[] = "$key = $value";
            }
        }
        $implodeArray = implode(', ', $updates);
        $sql = ("UPDATE $table SET $implodeArray WHERE $condition");
        $result = mysqli_query($sql);
        return $result;
    }

    public function Common_SQL_Insert($table, $data, $condition, $exclude = array()) {
        $fields = $values = array();
        if (!is_array($exclude))
            $exclude = array($exclude);
        foreach (array_keys($data) as $key) {
            if (!in_array($key, $exclude)) {
                $fields[] = "`$key`";
                $values[] = "'" . mysqli_real_escape_string($this->conn,$data[$key]) . "'";
            }
        }
        $fields = implode(",", $fields);
        $values = implode(",", $values);
        $sql = ("SELECT COUNT(*) as cnt From $table  WHERE $condition");
        $result = mysqli_query($this->conn,$sql);
        $tot_cnt = mysqli_fetch_assoc($result);

        if ($tot_cnt['cnt'] > 0) {
            return array("mysqli_error" => "Already Exist");
        } else {
            if (mysqli_query($this->conn,"INSERT INTO `$table` ($fields) VALUES ($values) ")) {
                return array("mysqli_error" => false,
                    "mysqli_insert_id" => mysqli_insert_id($this->conn),
                    "mysqli_affected_rows" => mysqli_affected_rows($this->conn),
                    "mysqli_info" => mysqli_info($this->conn)
                );
            } else {
                return array("mysqli_error" => mysqli_error($this->conn));
            }
        }
    }

    function get_Office_Details() {
        $sql = "SELECT * FROM office_details WHERE status !='2'";
        $result = mysqli_query($this->conn,$sql);
        return $result;
    }

    function update_Office_Status($ofcid, $statusid) {
        $sql = "SELECT * FROM office_details WHERE office_id = $ofcid and status ='1'";
        $result = mysqli_query($this->conn,$sql);
        return $result;
    }

    function get_Update_Office_Details($ofcid) {
        $sql = "SELECT * FROM office_details WHERE office_id = $ofcid and status ='1'";
        $result = mysqli_query($this->conn,$sql);
        $data = mysqli_fetch_assoc($result);
        return $data;
    }

    function get_Service_Details() {
        $sql = "SELECT * FROM office_category_service WHERE  status ='1'";
        $result = mysqli_query($this->conn,$sql);
        return $result;
    }

    function get_Service_Category_Details() {
        $sql = "SELECT * FROM office_category_service WHERE  status='1'";
        $result = mysqli_query($this->conn,$sql);
        return $result;
    }
    
    function get_Service_Category_Details_by_id($service_id) {
        $sql = "SELECT * FROM office_category_service WHERE service_id ='$service_id' AND   status !='2'";
       
        $result = mysqli_query($this->conn,$sql);
        $data = mysqli_fetch_assoc($result);
        return $data;
    }
    function get_Update_Service_Details($serviceid) {
        $sql = "SELECT * FROM office_category_service WHERE service_id = $serviceid and status ='1'";
        $result = mysqli_query($this->conn,$sql);
        $data = mysqli_fetch_assoc($result);
        return $data;
    }

}

$OfficeClassDet = new OfficeClassDet();
?>
