<?php

class ClassDepartments {

    protected $conn;

    public function __construct() {
        $this->DbConnect();
    }

    protected function DbConnect() {
        include "dbconfig.php";
        date_default_timezone_set('Asia/Kolkata');
        $this->conn = mysqli_connect($host, $user, $password) OR die("Unable to connect to the database");
        mysqli_select_db($this->conn,$db) OR die("can not select the database $db");
        return TRUE;
    }

    public function clean($str) {
        $str = @trim($str);
        if (get_magic_quotes_gpc()) {
            $str = stripslashes($str);
        }
        return mysqli_real_escape_string($this->conn,$str);
    }

    function f_mysql_insert_array($table, $data, $exclude = array()) {
        $fields = $values = array();
        if (!is_array($exclude))
            $exclude = array($exclude);
        foreach (array_keys($data) as $key) {
            if (!in_array($key, $exclude)) {
                $fields[] = "`$key`";
                $values[] = "'" . mysqli_real_escape_string($this->conn,$data[$key]) . "'";
            }
        }
        $fields = implode(",", $fields);
        $values = implode(",", $values);
        if (mysqli_query($this->conn,"INSERT INTO `$table` ($fields) VALUES ($values)")) {
            return array("mysqli_error" => false,
                "mysqli_insert_id" => mysqli_insert_id($this->conn),
                "mysqli_affected_rows" => mysqli_affected_rows(),
                "mysqli_info" => mysqli_info()
            );
        } else {
            return array("mysqli_error" => mysqli_error());
        }
    }

    function check_practice_area_exist($practice_area) {
        $sql = "SELECT * FROM practice WHERE LOWER(TRIM(practice_area))=LOWER(TRIM('$practice_area')) AND status!='3'";
        $result = mysqli_query($this->conn,$sql);
        return mysqli_affected_rows($this->conn);
    }

    function fetch_practice_area_details($id) {
        $query = "SELECT * FROM practice WHERE status!='3'";
        $result = mysqli_query($this->conn,$query);
        return $result;
    }

    function check_office_details_exist($office_name) {
        $sql = "SELECT *  FROM office WHERE LOWER(TRIM(office_name))=LOWER(TRIM('$office_name')) AND status!='3'";
        $result = mysqli_query($this->conn,$sql);
        return mysqli_affected_rows($this->conn);
    }

    function fetch_all_office_details($id) {
        $sql = "SELECT * FROM office WHERE status!='3'";
        $result = mysqli_query($this->conn,$sql);
        return $result;
    }

    function check_subpractice_area_exist($subpractice_area) {
        $sql = "SELECT count(*) AS num_count FROM subpractice WHERE LOWER(TRIM(subpractice_area))=LOWER(TRIM('$subpractice_area')) AND status!='3'";
        $result = mysqli_query($this->conn,$sql);
        $array = mysqli_fetch_assoc($result);
        return $array['num_count'];
    }

    function Get_subpractice_details($subpractice_id) {
        $sql = "SELECT * FROM add_subpractice WHERE status !='3' AND subpractice_id='$subpractice_id'";
        $result = mysqli_query($this->conn,$sql);
        $array = mysqli_fetch_assoc($result);
        return $array;
    }

    function fetch_subpractice_area_details($id) {
        $query = "SELECT * FROM subpractice WHERE status!='3'AND practice_id={$practice_area}";
        $result = mysqli_query($this->conn,$query);
        return $result;
    }

    function check_staff_name_exist($staff_name) {
        $sql = "SELECT count(*) as count_flag FROM staff WHERE LOWER(TRIM(staff_name))=LOWER(TRIM('$staff_name')) AND status!='3'";
        $result_set = mysqli_query($this->conn,$sql);
        $result = mysqli_fetch_assoc($result_set);
        return $result['count_flag'];
    }

}

$ClassDepartments = new ClassDepartments();
?>
