<?php

class ClassClipArts {

    protected $conn;

    public function __construct() {
        $this->DbConnect();
    }

    protected function DbConnect() {
        include "dbconfig.php";
        date_default_timezone_set('Asia/Kolkata');
        $this->conn = mysqli_connect($host, $user, $password) OR die("Unable to connect to the database");
        mysqli_select_db( $this->conn,$db) OR die("can not select the database $db");
        return TRUE;
    }

    public function clean($str) {
        $str = @trim($str);
        if (get_magic_quotes_gpc()) {
            $str = stripslashes($str);
        }
        return mysqli_real_escape_string($str);
    }

    ######################## 
    # General function to insert associative arry to table
    # Modified : Nagarajan   Version:1.0
    # Date: 16/Feb/2015

    function f_mysql_insert_array($table, $data, $exclude = array()) {
        $fields = $values = array();
        if (!is_array($exclude))
            $exclude = array($exclude);
        foreach (array_keys($data) as $key) {
            if (!in_array($key, $exclude)) {
                $fields[] = "`$key`";
                $values[] = "'" . mysqli_real_escape_string($data[$key]) . "'";
            }
        }
        $fields = implode(",", $fields);
        $values = implode(",", $values);
        if (mysqli_query("INSERT INTO `$table` ($fields) VALUES ($values)")) {
            return array("mysqli_error" => false,
                "mysqli_insert_id" => mysqi_insert_id(),
                "mysqli_affected_rows" => mysqli_affected_rows(),
                "mysqli_info" => mysqli_info()
            );
        } else {
            return array("mysqli_error" => mysqli_error());
        }
    }

    public function Function_Update_SQL($array, $table, $condition) {

        if (count($array) > 0) {
            foreach ($array as $key => $value) {

                $value = mysqli_real_escape_string($value); // this is dedicated to @Jon
                $value = "'$value'";
                $updates[] = "$key = $value";
            }
        }
        $implodeArray = implode(', ', $updates);
        $sql = ("UPDATE $table SET $implodeArray WHERE $condition");
        $result = mysqli_query($sql);
        return $result;
    }

    function Check_ClipArts_Catgry($app_id, $Category_Name) {
        $sql = "SELECT count(app_id) num_count FROM cliparts_category WHERE LOWER(TRIM(category_name))=LOWER(TRIM('$Category_Name')) AND app_id ='$app_id' AND status !='3'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['num_count'];
    }

    function GetAvailable_ClipArtsCategory($app_id) {
        $sql = "SELECT * FROM cliparts_category WHERE app_id='$app_id' AND status !='3'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Update_CACategory_Action($app_id, $CACategory_id, $action_val) {
        $sql = "UPDATE cliparts_category SET status='$action_val' WHERE app_id='$app_id' AND category_id='$CACategory_id'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Get_CACategory_Details($app_id, $CACategory_id) {
        $sql = "SELECT * FROM cliparts_category WHERE  category_id ='$CACategory_id' AND app_id='$app_id' AND status !='3'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array;
    }

    function Check_ClipArts_Catgry_update($app_id, $CACategory_id, $Category_Name) {
        $sql = "SELECT count(app_id) num_count FROM cliparts_category WHERE LOWER(TRIM(category_name))=LOWER(TRIM('$Category_Name')) AND app_id ='$app_id' AND category_id !='$CACategory_id' AND status !='3'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['num_count'];
    }

    function Get_CA_Category($app_id) {
        $sql = "SELECT * FROM cliparts_category WHERE app_id ='$app_id' AND status !='3'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Check_CA_Sub_Exisists($app_id, $category_id, $ca_sub_name) {
        $sql = "SELECT count(app_id) num_count FROM cliparts_subcategory WHERE LOWER(TRIM(subcategory_name))=LOWER(TRIM('$ca_sub_name')) AND app_id ='$app_id' AND category_id ='$category_id' AND status !='3'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['num_count'];
    }

    function Get_CA_SubCategory($app_id, $category_id) {
        $sql = "SELECT * FROM cliparts_subcategory WHERE app_id='$app_id' AND category_id='$category_id' AND status !='3'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Update_CA_Sub_Category_Action($app_id, $sub_category_id, $action_val) {
        $sql = "UPDATE cliparts_subcategory SET status='$action_val' WHERE app_id='$app_id' AND subcategory_id='$sub_category_id'";
        $result = mysqli_query($sql);
        return $result;
    }

    function Get_CA_Sub_Details($app_id, $ca_sub_category) {
        $sql = "SELECT * FROM cliparts_subcategory WHERE subcategory_id ='$ca_sub_category' AND app_id='$app_id' AND status !='3'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array;
    }

    function Check_CA_sub_Catgry_update($app_id, $ca_sub_cat_id, $Sub_Category_Name) {
        $sql = "SELECT count(app_id) num_count FROM cliparts_subcategory WHERE LOWER(TRIM(subcategory_name))=LOWER(TRIM('$Sub_Category_Name')) AND app_id ='$app_id' AND subcategory_id !='$ca_sub_cat_id' AND status !='3'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['num_count'];
    }

    function get_ca_sub_img($app_id, $ca_sub_cat_id) {
        $sql = "SELECT subcategory_img FROM cliparts_subcategory WHERE subcategory_id ='$ca_sub_cat_id' AND app_id='$app_id'";
        $result = mysqli_query($sql);
        $array = mysqli_fetch_assoc($result);
        return $array['subcategory_img'];
    }

}

$ClassClipArts = new ClassClipArts();
?>
