<?php
error_reporting(E_ERROR | E_PARSE);
?>
<style>
.upload-area {
    /* width: 70%; */
    height: 200px;
    border: 2px solid lightgray;
    border-radius: 3px;
    margin: 0 auto;
    /* margin-top: 100px; */
    text-align: center;
    overflow: auto;
}

.upload-area:hover {
    cursor: pointer;
}

.upload-area h5 {
    text-align: center;
    font-weight: normal;
    font-family: sans-serif;
    /* line-height: 50px; */
    color: darkslategray;
}

#file {
    display: none;
}

/* Thumbnail */
.thumbnail {
    width: 80px;
    height: 80px;
    padding: 2px;
    border: 2px solid lightgray;
    border-radius: 3px;
    float: left;
}

.size {
    font-size: 12px;
}
</style>
<div class="container-md">
    <div class="row">
        <div class="col-6 col-md-6">
            <input type="file" name="file" id="file">
            <div class="upload-area col-12" id="uploadfile">
                <h5>Drag and Drop Zip file here<br />Or<br />Click to select Zip file</h5>
            </div>
            <br /><br /><br />
            <button class="btn btn-primary collg-4 m0 g_qr float-right">Upload Zip File</button>
            <div class="qrcode col-10 float-left"></div>
            <canvas id="mycanvas"></canvas>
        </div>
    </div>
</div>
<script>
$(document).ready(function () {
    $(document).ajaxStart(function () {
        $(".pr_myDivLoading").show();
    }).ajaxStop(function () {
        $(".pr_myDivLoading").hide();
    });
});
</script>
<script>
$(function() {    
    $("html").on("dragover", function(e) {
        e.preventDefault();
        e.stopPropagation();
        $("h5").text("Drag here");
    });

    $("html").on("drop", function(e) { e.preventDefault(); e.stopPropagation(); });

    // Drag enter
    $('.upload-area').on('dragenter', function (e) {
        e.stopPropagation();
        e.preventDefault();
        $("h5").text("Drop");
    });

    // Drag over
    $('.upload-area').on('dragover', function (e) {
        e.stopPropagation();
        e.preventDefault();
        $("h5").text("Drop");
    });

    // Drop
    $('.upload-area').on('drop', function (e) {
        e.stopPropagation();
        e.preventDefault();
        var file = e.originalEvent.dataTransfer.files;
        var extension =  file[0].name.split('.').pop().toLowerCase();    
        var validFileExtensions = ['zip','rar' ];
        if ($.inArray(extension, validFileExtensions) == -1){
            $(this).replaceWith($(this).val('').clone(true));
            swal('Warning',"Please select valid file");
        }
        else{
            var dispData = "<div> File Name :"+file[0].name+" </div><div> Size :"+convertSize(file[0].size)+"</div>";
            $("h5").html(dispData);

            var fd = new FormData();
            fd.append('file', file[0]);
            uploadData(fd);
        }
    });

    $("#uploadfile").click(function(){
        $("#file").click();
    });

    // file selected
    $("#file").change(function(){    
        var extension =  $(this).val().split('.').pop().toLowerCase();    
        var validFileExtensions = ['zip','rar' ];
        if ($.inArray(extension, validFileExtensions) == -1){
            $(this).replaceWith($(this).val('').clone(true));
            swal('warning',"Please select valid file");
        }
        else{            
            var file_data = $('#file').prop('files')[0];
            var fd = new FormData();
            fd.append('file', file_data);
            uploadData(fd);
        }
    });

});
// Bytes conversion
function convertSize(size) {
var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'];
if (size == 0) return '0 Byte';
var i = parseInt(Math.floor(Math.log(size) / Math.log(1024)));
return Math.round(size / Math.pow(1024, i), 2) + ' ' + sizes[i];
}

function uploadData(formdata){
    $.ajax({
        url: 'rane/domestic/extract_zip.php',
        type: 'post',
        data: formdata,
        contentType: false,
        processData: false,
        dataType: 'JSON',
        success: function(res){
            console.log('res');
            if(res.status){
                swal(res.message);
            }
            else{
                swal(res.message);
            }
        }
    });
}

function printQR(data){
    var details = data.json;    
    var loc = data.loc;    
    $('#hdn_JsonUrl').val(post_data);
    var post_data = details.SignedQRCode;
    $.ajax({
        url : 'qr/index.php?data='+post_data,
        type : 'GET',        
        success : function(response){
            $('.qrcode').html(response);           
            $('#hdn_JsonData').val(post_data);
        }
    });
                
}

function addThumbnail(data){
    $("#uploadfile h5").remove(); 
    var len = $("#uploadfile div.thumbnail").length;
    var num = Number(len);
    num = num + 1;
    var name = data.name;
    var size = convertSize(data.size);
    var src = data.src;
    // Creating an thumbnail
    $("#uploadfile").append('<div id="thumbnail_'+num+'" class="thumbnail"></div>');
    $("#thumbnail_"+num).append('<img src="'+src+'" width="100%" height="78%">');
    $("#thumbnail_"+num).append('<span class="size">'+size+'<span>');

}

function LoadList(){
  $.ajax({
    url: 'pages/list_inv.php',     
    //dataType: 'text',  
    //cache: false,
    //contentType: false,
    //processData: false,
    //            data: form_data,                         
    //type: 'post',
    success: function(php_script_response){                
      $('#ListInvoices').html(php_script_response);
      $('.tesla').DataTable();
    }
  });
}
</script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>