<?php
    function CreatePdf($data,$Qrsource,$destination){
        extract($data);
        include '../../pages/state_master.php';        
        require_once('../../tcpdf/tcpdf_import.php');
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $border = array('width' => 0.25, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(220,20,60));
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('S. Prabhu');
        $pdf->SetTitle('RNHS Invoice');
        $pdf->SetSubject('Invoice');
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('S. Prabhu');
        $pdf->SetTitle('RNHS Invoice');
        $pdf->SetSubject('Invoice');
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);// set margins
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);
        if (@file_exists(dirname(__FILE__).'../../tcpdf/lang/eng.php')) {
            require_once(dirname(__FILE__).'../../tcpdf/lang/eng.php');
            $pdf->setLanguageArray($l);
        }    
        $pdf->AddPage();
        $pdf->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(220,20,60)));
        $pdf->RoundedRect(15,17,180,255,0,'1111');
        //$pdf->SetTextColor(220,20,60);
        $pdf->SetFont('helvetica', 'B', 12);
        $pdf->Text(85,19,"TAX INVOICE");
        $pdf->SetFont('helvetica', '', 11);
        $pdf->SetFont('helvetica', '', 9.5);
        $pdf->MultiCell(54,6,"(Under Section 31 of SGST Act CGST Act along with section 20 of IGST Act)",0,'L',false,30,137,27);
        $pdf->Line(15,25,195,25,$border);    
        $pdf->Image(__DIR__."/../../images/RaneLogo.png",16,26,17,10);
        $pdf->SetFont('helvetica', 'B', 25);
        //$pdf->Text(32,25,"NSK");
        
        $pdf->SetFont('helvetica', '', 9.5);
        //$pdf->Text(60,25,$SellerDtls['LglNm']);
        //$pdf->Text(60,30,$SellerDtls['Addr1']);
        //$pdf->Text(60,35,$SellerDtls['Addr2']);
        //$pdf->Text(60,40,$state_list[$SellerDtls['Stcd']]."(".$SellerDtls['Stcd'].") -".$SellerDtls['Pin']);
        $McellData = $SellerDtls['LglNm']."\n".$SellerDtls['Addr1']."\n".$SellerDtls['Addr2']."\n".$state_list[$SellerDtls['Stcd']]."(".$SellerDtls['Stcd'].") -".$SellerDtls['Pin'];
        $pdf->MultiCell(75,6,$McellData,0,'L',false,80,60,25);
        
        $pdf->Line(58, 25, 58, 46, $border);
        $pdf->Line(136, 25, 136, 46, $border);
        $pdf->Line(15,46,195,46,$border);
        $pdf->Line(80, 46, 80, 130, $border);
        $pdf->SetFont('helvetica', 'B', 9);
        $pdf->Text(16,46,"Details of the Receiver (Billed to)");
        $pdf->Line(17,50,67,50,$border);    
        $pdf->SetFont('helvetica', '', 8.5);   
        $pdf->SetTextColor(0,0,0);
        
        // Data Entries
        $pdf->Text(16,50,$BuyerDtls['LglNm']);
        $pdf->Text(16,55,$BuyerDtls['Addr1']);
        $pdf->Text(16,59,$BuyerDtls['Loc']);
        $pdf->Text(16,63,$state_list[$BuyerDtls['Stcd']]." (".$BuyerDtls['Stcd'].") - ".$BuyerDtls['Pin']);
        //$pdf->SetTextColor(220,20,60);
        $pdf->Text(80,46,"IRN : ".$Irn);         // IRN
        $pdf->Text(80,50,"OUR GSTIN  : ".$SellerDtls['Gstin']);  // GSTIN
        $pdf->Text(80,54,"INVOICE N0 : ".$DocDtls['No']);  // INVOICE NO
        $pdf->Text(80,58,"INOVICE DATE : ".$DocDtls['Dt']);  // INVOICE DATE        
        $pdf->SetTextColor(0,0,0);
        $pdf->Image($Qrsource,139,50,55,55);
        //$pdf->SetTextColor(220,20,60);
        $pdf->SetFont('helvetica', 'B', 9);
        $pdf->Text(80,65,"Details of the Consignee (Shipped to)");
        $pdf->Line(80,69,138,69,$border);   
        $pdf->SetFont('helvetica', '', 9);
        $pdf->SetTextColor(0,0,0);
        $pdf->Text(80,70,$BuyerDtls['LglNm']);
        $pdf->Text(80,74,$BuyerDtls['Addr1']);
        $pdf->Text(80,78,$BuyerDtls['Loc']);
        $pdf->Text(80,82,$state_list[$BuyerDtls['Stcd']]." (".$BuyerDtls['Stcd'].") - ".$BuyerDtls['Pin']);
        //$pdf->SetTextColor(220,20,60);
        $pdf->Text(80,86,"SAP Doc Ref : ".$DocDtls['No']);
        $pdf->Text(80,90,"State (Code) : ".$state_list[$BuyerDtls['Stcd']]." (".$BuyerDtls['Stcd'].")");
        $pdf->Text(80,94,"GSTIN : ".$BuyerDtls['Gstin']);
        $pdf->Text(80,98,"PAN: ".substr($BuyerDtls['Gstin'],2,-3));
        $pdf->Text(80,102,"Code : ");
        $pdf->SetFont('helvetica', '', 9); 
        
        $pdf->Text(16,68,"Place of Supply");
        $pdf->Text(16,72,"GSTIN");
        $pdf->Text(16,76,"PAN ");
        $pdf->Text(16,80,"Code");
        $pdf->Text(16,84,"Cust Ord No/DT");
        $pdf->Text(16,88,"Our Ord No");
        $pdf->Text(16,92,"Our Del No");
        $pdf->Text(16,96,"ASN Details");
        $pdf->Text(16,100,"Code");

        $pdf->SetTextColor(0,0,0);
        $pdf->Text(43,68,": ".$state_list[$BuyerDtls['Pos']]." (".$BuyerDtls['Pos'].")");
        $pdf->Text(43,72,": ".$BuyerDtls['Gstin']);
        $pdf->Text(43,76,": ".substr($BuyerDtls['Gstin'],2,-3));
        $pdf->Text(43,80,": ");
        $pdf->Text(43,84,": ");
        $pdf->Text(43,88,": ");
        $pdf->Text(43,92,": ");
        $pdf->Text(43,96,": ");
        $pdf->Text(43,100,": ");
        //$pdf->SetTextColor(220,20,60);
        $pdf->Line(15,106,195,106,$border);  
        $pdf->Text(16,106,"Transporter Name");
        $pdf->Text(16,110,"LR No.");
        $pdf->Text(16,114,"Mode of Transport");
        $pdf->Text(16,118,"No. of Packages");
        $pdf->Text(16,122,"Our PAN");
        $pdf->Text(16,126,"CIN");
        $pdf->SetTextColor(0,0,0);
        
        $pdf->MultiCell(40,2,$EwbDtls['TransName'],0,'L',false,20,43,106);
        //$pdf->Text(43,106,": ".$EwbDtls['TransName']);
        
        $pdf->Text(43,110,": ");
        $pdf->Text(43,114,": ".$Eway_mot[$EwbDtls['TransMode']]);
        $pdf->Text(43,118,": ");
        $pdf->Text(43,122,": ".substr($SellerDtls['Gstin'],2,-3));  
        $pdf->Text(35,126,": ");  
        //$pdf->SetTextColor(220,20,60);
        $pdf->Text(80,106,"Payment Term   : ");
        $pdf->Text(80,110,"Inco Terms     : Freight Paid");
        $pdf->Text(80,114,"Insurance      : By Us");
        $pdf->Text(80,118,"EWay Bill No   : ".$EwbNo);
        $pdf->Text(80,122,"EWay Bill Date : ".$EwbDt);
        $pdf->Line(15,140,195,140,$border);    

        $pdf->Text(20,130,"Part Number / HSN Code");
        $pdf->Text(60,130,"Qty");
        $pdf->MultiCell(20,10,"Unit Rate (Per Item)",0,'L',false,20,75,130);
        $pdf->Text(90,130,"Total");
        $pdf->Text(105,130,"Discount");
        $pdf->Text(120,130,"taxable");
        $pdf->Text(135,130,"SGST value");
        $pdf->Text(155,130,"CGST value");
        $pdf->Text(175,130,"IGST value");
        $pdf->Text(20,135,"Description of Goods./  Cust. Part");
        $pdf->Text(140,135,"Rate");
        $pdf->Text(160,135,"Rate");
        $pdf->Text(180,135,"Rate");
        $pdf->Line(15,130,195,130,$border);

        $sl = 0;
        $start = 142;
        $pdf->SetTextColor(0,0,0);
        $sumQty = 0;
        foreach($ItemList as $item ){
            $sl++;
            $sumQty += floatval($item['Qty']);            
            $pdf->Text(16,$start,$item['SlNo']);
            $pdf->Text(20,$start,$item['HsnCd']);
            $pdf->Text(58,$start,$item['Qty']);
            $pdf->Text(68,$start,$item['Unit']."   ".$item['UnitPrice']);
            $pdf->Text(91,$start,$item['TotAmt']);
            $pdf->Text(108,$start,$item['Discount']);
            $pdf->Text(120,$start,$item['AssAmt']);
            $pdf->Text(140,$start,$item['SgstAmt']);
            $pdf->Text(156,$start,$item['CgstAmt']);
            //$pdf->Text(176,$start,$vatCst);
            $pdf->Text(176,$start,$item['IgstAmt']);
          
            $start += 4;
            $pdf->Text(20,$start,$item['PrdDesc']);
            $pdf->Text(140,$start,($item['GstRt']/2)." %");
            $pdf->Text(160,$start,($item['GstRt']/2)." %");
            $pdf->Text(176,$start,$item['GstRt']." %");

            //$pdf->Text(180,$start,$item['tax_rate']);
            
            $start += 6;
        }
        $pdf->SetTextColor(0,0,0);   
        //$pdf->SetTextColor(220,20,60);
        $amtinWord = strtoupper(getIndianCurrencyIn(floatval(str_replace(',', '', $ValDtls['TotInvVal']))));
        $cstAmt = $ValDtls['CgstVal'] + $ValDtls['SgstVal'] + $ValDtls['IgstVal'];
        $CSTamtinWord = strtoupper(getIndianCurrencyIn(floatval($cstAmt)));
        $pdf->Line(15,200,195,200,$border);
        $pdf->Text(16,200,"Total Qty");
        $pdf->Text(70,200,$sumQty);
        $pdf->Text(120,200,$ValDtls['AssVal']);
        $pdf->Text(140,200,$ValDtls['SgstVal']);
        $pdf->Text(156,200,$ValDtls['CgstVal']);
        $pdf->Text(176,200,$ValDtls['IgstVal']);

        $pdf->Text(16,208,"Total GST Value (INR)  ");
        $pdf->Text(16,212,"In Words: ".$CSTamtinWord);
        $pdf->Text(160,212,$TotInvVal);
        $pdf->Text(16,220,"Total Invoice Value (INR) ");
        $pdf->Text(170,220,$ValDtls['TotInvVal']);
        $pdf->Text(16,224,"In Words: ".$amtinWord);
        $pdf->Line(15,228,195,228,$border);
        $pdf->Text(16,228,"If tax payable under reverse charge - No ");
        $pdf->Text(16,232,"Declaration");
        $pdf->Text(16,236,"Certified that the particulars given above are true and the amountindicated represents the price actually");
        $pdf->Text(16,240,"charged and that there is no flow of additional consideration directly or indirectly from the buyer.");
        $pdf->Text(16,250,"Electronic Reference Number");
        $pdf->Text(155,250,"Authorised signatory");
        $pdf->SetFont('helvetica', 'B', 10);
        $pdf->Line(15,260,195,260,$border);    
        //$pdf->Text(16,260,"Original Equip. Spare");
        //$pdf->Text(16,265,"Steering Columns");
        $fn = '/'.Ranefilename($DocDtls['No']);
        $pdf->Output(__DIR__.$fn.".PDF", 'F');  
        //$pdf->Output(__DIR__.'/Output/CreditNotes_'.filename($inv_no).'.pdf', 'F');

        //$pdf->Output(dirname(__FILE__)."/".$destination,'F');
        rename(__DIR__.$fn.".PDF",$destination);
    }
    function Ranefilename($unsafeFilename){
        $dangerousCharacters = array(" ", '"', "'", "&", "/", "\\", "?", "#");
        $safe_filename = str_replace($dangerousCharacters, '_', $unsafeFilename);  
        return $safe_filename;
    }
    function getIndianCurrencyIn(float $number){
        $decimal = round($number - ($no = floor($number)), 2) * 100;
        $hundred = null;
        $digits_length = strlen($no);
        $i = 0;
        $str = array();
        $words = array(0 => '', 1 => 'one', 2 => 'two',
            3 => 'three', 4 => 'four', 5 => 'five', 6 => 'six',
            7 => 'seven', 8 => 'eight', 9 => 'nine',
            10 => 'ten', 11 => 'eleven', 12 => 'twelve',
            13 => 'thirteen', 14 => 'fourteen', 15 => 'fifteen',
            16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen',
            19 => 'nineteen', 20 => 'twenty', 30 => 'thirty',
            40 => 'forty', 50 => 'fifty', 60 => 'sixty',
            70 => 'seventy', 80 => 'eighty', 90 => 'ninety');
        $digits = array('', 'hundred','thousand','lakh', 'crore');
        while( $i < $digits_length ) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str [] = ($number < 21) ? $words[$number].' '. $digits[$counter]. $plural.' '.$hundred:$words[floor($number / 10) * 10].' '.$words[$number % 10]. ' '.$digits[$counter].$plural.' '.$hundred;
            } else $str[] = null;
        }
        $Rupees = implode('', array_reverse($str));
        $paise = ($decimal > 10) ? "." . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
        return ($Rupees ? $Rupees . 'Rupees ' : '') . $paise;
    }
    
?>