<?php
error_reporting(E_ERROR | E_PARSE);
define('_File_Loc', dirname(__FILE__));
// echo _File_Loc;
?>
<style>
.upload-area {
    /* width: 70%; */
    height: 200px;
    border: 2px solid lightgray;
    border-radius: 3px;
    margin: 0 auto;
    /* margin-top: 100px; */
    text-align: center;
    overflow: auto;
}

.upload-area:hover {
    cursor: pointer;
}

.upload-area h5 {
    text-align: center;
    font-weight: normal;
    font-family: sans-serif;
    /* line-height: 50px; */
    color: darkslategray;
}

#file {
    display: none;
}

/* Thumbnail */
.thumbnail {
    width: 80px;
    height: 80px;
    padding: 2px;
    border: 2px solid lightgray;
    border-radius: 3px;
    float: left;
}

.size {
    font-size: 12px;
}
</style>
<div class="container-md">
    <div class="row">
        <div class="col-6 col-md-6">
            <input type="file" name="file" id="file">
            <div class="upload-area col-12" id="uploadfile">
                <h5>Drag and Drop Zip file here<br />Or<br />Click to select Zip file</h5>
            </div>
            <br /><br /><br />
            <button class="btn btn-primary collg-4 m0 g_qr float-right">Upload Zip File</button>
            <div class="qrcode col-10 float-left"></div>
            <canvas id="mycanvas"></canvas>
        </div>
    </div>
</div>
<script>
$(document).ready(function () {
    $(document).ajaxStart(function () {
        $(".pr_myDivLoading").show();
    }).ajaxStop(function () {
        $(".pr_myDivLoading").hide();
    });
});
</script>
<script>
$(document).on('paste', function(evt) {
    evt.preventDefault();    
    var items = (evt.clipboardData || evt.originalEvent.clipboardData).items;
    console.log(items);
    for (var i = 0; i < evt.originalEvent.clipboardData.items.length; i++) {
        var item = evt.originalEvent.clipboardData.items[i];
        console.log("Item type value: " + item.type.indexOf("file"));
        if (item.type.indexOf("image") != -1) {
            //uploadFile(item.getAsFile());
            //$('#uploadfile').html(item.getAsFile());
            var blob = item.getAsFile();
            var canvas = document.getElementById("mycanvas");
            var ctx = canvas.getContext('2d');

            // Create an image to render the blob on the canvas
            var img = new Image();

            // Once the image loads, render the img on the canvas
            img.onload = function() {
                // Update dimensions of the canvas with the dimensions of the image
                canvas.width = this.width;
                canvas.height = this.height;

                // Draw the image
                ctx.drawImage(img, 0, 0);
            };

            // Crossbrowser support for URL
            var URLObj = window.URL || window.webkitURL;

            // Creates a DOMString containing a URL representing the object given in the parameter
            // namely the original Blob
            img.src = URLObj.createObjectURL(blob);

        } else {
            console.log("Discarding non-image paste data");
            swal('Warning', 'Access denied by browser or securty measures');
        }
    }
});
</script>
<script>
$(function() {

    
    $("html").on("dragover", function(e) {
        e.preventDefault();
        e.stopPropagation();
        $("h5").text("Drag here");
    });

    $("html").on("drop", function(e) { e.preventDefault(); e.stopPropagation(); });

    // Drag enter
    $('.upload-area').on('dragenter', function (e) {
        e.stopPropagation();
        e.preventDefault();
        $("h5").text("Drop");
    });

    // Drag over
    $('.upload-area').on('dragover', function (e) {
        e.stopPropagation();
        e.preventDefault();
        $("h5").text("Drop");
    });

    // Drop
    $('.upload-area').on('drop', function (e) {
        e.stopPropagation();
        e.preventDefault();
        var file = e.originalEvent.dataTransfer.files;
        var extension =  file[0].name.split('.').pop().toLowerCase();    
        var validFileExtensions = ['zip','rar' ];
        if ($.inArray(extension, validFileExtensions) == -1){
            $(this).replaceWith($(this).val('').clone(true));
            swal('Warning',"Please select valid file");
        }
        else{
            var dispData = "<div> File Name :"+file[0].name+" </div><div> Size :"+convertSize(file[0].size)+"</div>";
            $("h5").html(dispData);

            var fd = new FormData();
            fd.append('file', file[0]);
            uploadData(fd);
        }
    });

    $("#uploadfile").click(function(){
        $("#file").click();
    });

    // file selected
    $("#file").change(function(){    
        var extension =  $(this).val().split('.').pop().toLowerCase();    
        var validFileExtensions = ['zip','rar' ];
        if ($.inArray(extension, validFileExtensions) == -1){
            $(this).replaceWith($(this).val('').clone(true));
            swal('warning',"Please select valid file");
        }
        else{            
            var file_data = $('#file').prop('files')[0];
            var fd = new FormData();
            fd.append('file', file_data);
            uploadData(fd);
        }
    });

});
// Bytes conversion
function convertSize(size) {
var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'];
if (size == 0) return '0 Byte';
var i = parseInt(Math.floor(Math.log(size) / Math.log(1024)));
return Math.round(size / Math.pow(1024, i), 2) + ' ' + sizes[i];
}

function uploadData(formdata){
    $.ajax({
        url: 'pages/zip/extract_zip.php',
        type: 'post',
        data: formdata,
        contentType: false,
        processData: false,
        dataType: 'json',
        success: function(response){
            swal(response.status_info);
            //addThumbnail(response);
            // printQR(response);
            // printDetails(response);
            
        }
    });
}

function printQR(data){
    var details = data.json;    
    var loc = data.loc;    
    $('#hdn_JsonUrl').val(post_data);
    var post_data = details.SignedQRCode;
    $.ajax({
        url : 'qr/index.php?data='+post_data,
        type : 'GET',        
        success : function(response){
            $('.qrcode').html(response);           
            $('#hdn_JsonData').val(post_data);
        }
    });
                
}

// $('#submitBtn').click(function(){
//     var extension = $('#excel_file').val().split('.').pop().toLowerCase();
//     var validFileExtensions = ['xls', 'xlsb', 'xlsx', 'xlsm', 'xlw', 'xps','xml' ];
//     if ($.inArray(extension, validFileExtensions) == -1){
//         $(this).replaceWith($(this).val('').clone(true));
//         swal("Warning","Please select valid file");
//     }
//     else{
//         var Qr_data = $('#hdn_JsonData').val();
//         var Json_Furl = $('#hdn_JsonUrl').val();
//         var Inv_no = $('#DocNo').val();
//         var Inv_Date = $('#DocDt').val();
//         var SellerGstin = $('#SellerGstin').val();
//         var BuyerGstin = $('#BuyerGstin').val();
//         var TotInvVal = $('#TotInvVal').val();
//         var ItemCnt = $('#ItemCnt').val();
//         var Irn = $('#Irn').val();
//         var Qr_url = $('#ImageUrl').val();

//         //var Qr_data = $('#SellerGstin').val();
//         //var Qr_data = $('#SellerGstin').val();
//         var file_data = $('#excel_file').prop('files')[0];   
//         var form_data = new FormData();                  
//         form_data.append('Qr_data', Qr_data);
//         form_data.append('Inv_no', Inv_no);
//         form_data.append('Inv_Date', Inv_Date);
//         form_data.append('SellerGstin', SellerGstin);
//         form_data.append('BuyerGstin', BuyerGstin);
//         form_data.append('TotInvVal', TotInvVal);
//         form_data.append('ItemCnt', ItemCnt);
//         form_data.append('Irn', Irn);
//         form_data.append('Qr_url', Qr_url);
//         form_data.append('excel_file', file_data);
//         form_data.append('json_url', Json_Furl);

//         //$(this).hide();
              
//         $.ajax({
//             url: 'pages/save_invoice.php', 
//             // url: 'tools/save_excel.php',
//             dataType: 'JSON',  
//             cache: false,
//             contentType: false,
//             processData: false,
//             data: form_data,                         
//             type: 'post',
//             success: function(php_script_response){                
//                   //$('#download_link').show();
//                   swal('uploaded Successfully');
//                   swal(php_script_response.status_info)
//                 LoadList();
//             }
//         });

//         $('.upload').show();
//     }
// }); 

// function printDetails(data){
//     var details = data.json;
//     var post_data = details.SignedQRCode;
//     $.ajax({
//         url : 'tools/decrypt_QR.php?data='+post_data,
//         type : 'GET',
//         success : function(response){
//             $('.qrcode_details > textarea').val(response);    
//             $('.qrcode_details > textarea').show();                        
//             var json = $.parseJSON(response);
//             var datas = $.parseJSON(json.data);
//             $('#SellerGstin').val(datas['SellerGstin']);
//             $('#BuyerGstin').val(datas['BuyerGstin']);
//             $('#DocNo').val(datas['DocNo']);
//             $('#DocDt').val(datas['DocDt']);
//             $('#TotInvVal').val(datas['TotInvVal']);
//             $('#ItemCnt').val(datas['ItemCnt']);
//             $('#Irn').val(datas['Irn']);
//             $('.data_qr ').attr('readonly','readonly');
//             $('.g_qr').hide();
//             $('#hdn_JsonUrl').val(data.loc);
//             $('#form_data').show();
//         }
//     });
//     $('.upload').show();

// }

function addThumbnail(data){
    $("#uploadfile h5").remove(); 
    var len = $("#uploadfile div.thumbnail").length;
    var num = Number(len);
    num = num + 1;
    var name = data.name;
    var size = convertSize(data.size);
    var src = data.src;
    // Creating an thumbnail
    $("#uploadfile").append('<div id="thumbnail_'+num+'" class="thumbnail"></div>');
    $("#thumbnail_"+num).append('<img src="'+src+'" width="100%" height="78%">');
    $("#thumbnail_"+num).append('<span class="size">'+size+'<span>');

}

function LoadList(){
  $.ajax({
    url: 'pages/list_inv.php',     
    //dataType: 'text',  
    //cache: false,
    //contentType: false,
    //processData: false,
    //            data: form_data,                         
    //type: 'post',
    success: function(php_script_response){                
      $('#ListInvoices').html(php_script_response);
      $('.tesla').DataTable();
    }
  });
}
</script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>