<style>
.switch {
    position: relative;
    display: inline-block;
    width: 60px;
    height: 34px;
}

.switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    -webkit-transition: .4s;
    transition: .4s;
}

.slider:before {
    position: absolute;
    content: "";
    height: 26px;
    width: 26px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    -webkit-transition: .4s;
    transition: .4s;
}

input:checked+.slider {
    background-color: #2196F3;
}

input:focus+.slider {
    box-shadow: 0 0 1px #2196F3;
}

input:checked+.slider:before {
    -webkit-transform: translateX(26px);
    -ms-transform: translateX(26px);
    transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
    border-radius: 34px;
}

.slider.round:before {
    border-radius: 50%;
}
</style>
<div class="col-12">
    <div class="row col-12 text-center">
        <label class="col-4" style="color:red;">View all Login List</label>
        <label class="switch">
            <input type="checkbox" id="switchView">
            <span class="slider round"></span>
        </label>
    </div>
    <div class="row" id="panl_form">
        <form id="registration" name="registration" enctype="multipart/form-data" class="form-horizontal col-12"
            method="post" action="javascript:;">
            <div class="col-12">
                <input type="hidden" name="formMode" id="formMode" value="insert" />
                <div class="form-group row">
                    <label for="" class="col-4 float-left" for="c_name">Client Name</label>
                    <div class="col-4 float-right">
                        <input type="text" name="c_name" id="c_name" class="form-control"
                            placeholder="Enter Client Name" required />
                    </div>
                </div>
                <div class="form-group row">
                    <label for="" class="col-4 float-left" for="c_email">Login Email id</label>
                    <div class="col-4 float-right">
                        <input type="text" name="c_email" id="c_email" class="form-control"
                            placeholder="Enter Login Email" autocomplete="off" required />
                        <span class="email" style="color:red;"></span>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="" class="col-4 float-left">Login Password</label>
                    <div class="form-label-group col-4 float-right">
                        <input type="password" name="c_pwd" id="c_pwd" class="form-control" placeholder="Password"
                            required>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="" class="col-4 float-left">User Role</label>
                    <div class="col-4 float-right">
                        <select name="c_role" id="c_role" class="form-control" required>
                            <option value="0">Please Select Role</option>
                            <option value="admin">Admin</option>
                            <option value="client">Client</option>
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="" class="col-4 float-left" for="c_mobile">Contact Number</label>
                    <div class="col-4 float-right">
                        <input type="text" name="c_mobile" id="c_mobile" class="form-control" maxlength="10"
                            placeholder="Enter mobile number" required />
                    </div>
                </div>
                <div class="form-group col-12 text-center">
                    <input type="submit" value="submit" class="btn btn-primary float-center" />
                </div>
            </div>
        </form>
    </div>
    <div class="row" id="panl_list" style="display:show;">
        <div class="col-12" id="listRegisterdUser">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <td>User Name</td>
                        <td>User Email</td>
                        <td>User Password</td>
                        <td>User Role</td>
                    </tr>
                </thead>
                <tbody class="list_body">

                </tbody>
            </table>
        </div>
    </div>
</div>
<script>
function loadUserList() {
    $.ajax({
        url: 'admin/user_list.php',
        methd: 'GET',
        success: function(response) {
            $('.list_body').html(response);
        }
    });
}
$(document).ready(function() {
    loadUserList();
    $(prjSelect('#c_mobile')).bind('keypress', function(e) {
        var keyCode = e.which ? e.which : e.keyCode;
        if (!(keyCode >= 48 && keyCode <= 57)) {
            $(".error").css("display", "inline");
            return false;
        } else {
            $(".error").css("display", "none");
        }
    });
    $(prjSelect('#c_pwd')).mouseover(function() {

        if ($(this).attr('type') == 'password') {
            $(this).attr('type', 'text');
        }
    });
    $(prjSelect('#c_pwd')).mouseout(function() {
        if ($(this).attr('type') == 'text') {
            $(this).attr('type', 'password');
        }
    });

    $(prjSelect('#switchView')).click(function() {
        // if($(this).is(':checked')){
        //     console.log('checked');

        // }
        // else{
        //     console.log('un checked');
        // }
        $(prjSelect('#panl_form')).toggle(2000);
        $(prjSelect('#panl_list')).toggle(2000);
    });

    $('#listRegisterdUser').ready(function(e) {
        $.ajax({
            url: 'admin/loginCheck.php',
            methd: 'POST',
            data: {
                'inputEmail': val,
            },
            datatype: 'JSON',
            success: function(response) {
                var result = $.parseJSON(response);
                $(prjSelect('.email')).html(result.status_info);
                console.log(result.status_info);
            }
        });
    });

    $(prjSelect('#c_email')).on('keyup', function(e) {

        var val = $(this).val();
        console.log(val);
        $.ajax({
            url: 'admin/loginCheck.php',
            methd: 'POST',
            data: {
                'inputEmail': val,
            },
            datatype: 'JSON',
            success: function(response) {
                var result = $.parseJSON(response);
                $(prjSelect('.email')).html(result.status_info);
                console.log(result.status_info);
            }
        });
    })

    $(prjSelect('#registration')).on('submit', function(event) {
        event.preventDefault();
        console.log('form-submit function');
        var formData = new FormData($(this)[0]);
        $.ajax({
            url: 'admin/save_client.php',
            method: 'post',
            data: formData,
            datatype: 'json',
            contentType: false,
            processData: false,
            resetForm: true,
            success: function(res) {
                var result = $.parseJSON(res);
                if (result.status_code == 1) {
                    swal('Success', result.status_info);
                    $(this)[0].reset();
                } else {
                    swal('Warning', result.status_info);
                }
            }
        });
    });
})
</script>