<?php include_once('classes/UPI_QR_Generator.php'); 
      include_once('vendor/autoload.php');
      use Endroid\QrCode\QrCode;
?>
<!DOCTYPE html>

<html>

<head>
  <title>LMS QR Code</title>

  
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">

  
  <meta name="viewport" content="width=device-width, initial-scale=1">

  
  <link rel="stylesheet" href="//fonts.googleapis.com/css?family=Roboto:300,400,500,700" type="text/css" />
  <link href="//fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" type="text/css" />  
  <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" type="text/css" />
  <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" type="text/css" />
  <link rel="stylesheet" href="public/assets/css/custom.css">  
  <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>
  

</head>
<body>
          
<!-- main content -->

<div class="container">    
    <div class="row">           
        
            <div class="col-md-9">
                
                <?php
                
                $pa = $pn = $am = $tid = $tr = $tn = $url = '';
                
                if( isset($_POST['submit_qr_code']) ){

                    extract( $_POST );
                    
                    $merchant['pn'] = $pn;
                    $merchant['pa'] = $pa;
                    $merchant['am'] = $am;
                    $merchant['tid'] = $tid;
                    $merchant['tr'] = $tr;
                    $merchant['tn'] = $tn;
                    $merchant['url'] = $url;
                    
                    $qr_code = new UPI_QR_Generator( $merchant );                                                             

                    $upi_text = $qr_code ->generate_upi_text();                                

                    $qrCode = new QrCode();
                    $qrCode->setText($upi_text);
                    $qrCode->setSize(200);
                    $qrCode->setPadding(5);
                    $qrCode->setErrorCorrection('high');
                    //$qrCode   ->setForegroundColor(array('r' => 0, 'g' => 0, 'b' => 0, 'a' => 0));
                    //$qrCode    ->setBackgroundColor(array('r' => 255, 'g' => 255, 'b' => 255, 'a' => 0));
                    //$qrCode    ->setLabel('Scan the code');
                    //$qrCode    ->setLabelFontSize(16);
                    //$qrCode->setImageType(QrCode::IMAGE_TYPE_PNG);                              

                    $qrCode->save('./public/files/qrcodes/temp.png');
                    
                    $img = './public/files/qrcodes/temp.png';
                    
                    $qr_generated = 1;
                                        
                }else{
                    
                    $img = "./public/files/qrcodes/sample.png";
                    
                } ?>
                
                <form class="form-horizontal" id="form-generate-qr-code" data-parsley-validate="true" method="post">            

                <!-- Text input-->

                <div class="form-group">
                    <label class="col-md-3 control-label" for="pn"><i class="text-danger">*</i> Payee Name</label>  
                  <div class="col-md-9">
                  <input id="pn" name="pn" type="text" placeholder="Enter payee name" class="form-control" required value="<?php echo $pn;?>" />                  
                  </div>
                </div>

                <div class="form-group">
                  <label class="col-md-3 control-label" for="pa"><i class="text-danger">*</i> UPI ID</label>  
                  <div class="col-md-9">
                  <input id="pa" name="pa" type="text" placeholder="Enter payee virtual address" class="form-control" required value="<?php echo $pa;?>" />                  
                  </div>
                </div>
                
                               
                <div class="form-group">
                  <label class="col-md-3 control-label" for="am"> Amount</label>  
                  <div class="col-md-9">
                  <input id="am" name="am" type="number" placeholder="Enter payee amount" class="form-control" value="<?php echo $am;?>" />                  
                  </div>
                </div>
                
                <!-- <div class="form-group">
                  <label class="col-md-3 control-label" for="tid"> Merchant Code</label>  
                  <div class="col-md-9">
                  <input id="mc" name="mc" type="text" placeholder="Enter merchant code" class="form-control" value="<?php echo $tid;?>" />
                  <span class="help-block">( Merchant may acquire the txn id from his PSP )</span>  
                  </div>
                </div> -->
                
                <div class="form-group">
                  <label class="col-md-3 control-label" for="tr"> Invoice No </label>  
                  <div class="col-md-9">
                  <input id="tid" name="tid" type="text" placeholder="Enter Invoice No" class="form-control" value="<?php echo $tr;?>" />
                  
                  </div>
                </div>
                
                <div class="form-group">
                  <label class="col-md-3 control-label" for="tn"> Invoice Details </label>  
                  <div class="col-md-9">
                  <input id="tn" name="tn" type="text" placeholder="Enter transaction note" class="form-control" value="<?php echo $tn;?>" />
                  <span class="help-block">(  Short description of the transaction )</span>  
                  </div>
                </div>
                
                <div class="form-group">
                  <label class="col-md-3 control-label" for="url"> Reference URL </label>  
                  <div class="col-md-9">
                  <input id="url" name="url" type="url" placeholder="Enter reference URL" class="form-control" value="<?php echo $url;?>" />
                  <span class="help-block">(  URL which provides transaction details )</span>  
                  </div>
                </div>

                <!-- Button -->

                <div class="form-group">
                  <label class="col-md-3 control-label" for="generate-qr">Generate Qr Code</label>
                  <div class="col-md-9">
                      <button type="submit" name="submit_qr_code" id="generate-qr" name="generate-qr" class="btn btn-success">Submit</button>
                  </div>
                </div>

                </form>
            </div>

            <div class="col-md-3 text-center" align="center">
                
                <div>                      
                    <p> <img id="generated-qr-code" src = "<?php echo $img;?>" /> </p>
                    <p> <a title="Download PNG" data-toggle="tooltip" class="btn btn-sm btn-primary" href="<?php echo $img;?>" download="UPI-QR-Code"><i class="fa fa-image">Download QR code</i></a> &nbsp;
                        <!-- <a title="Download PDF" data-toggle="tooltip" class="btn btn-sm btn-info" href="<?php echo $img;?>" download="UPI-QR-Code.pdf"><i class="fa fa-file"></i></a> &nbsp; 
                        <a title="Print" data-toggle="tooltip" class="btn btn-sm btn-danger" href="<?php echo $img;?>" download="UPI-QR-Code"><i class="fa fa-print"></i></a> -->
                    </p>
                        
                <div>               

            </div>            
        
    </div>
    
</div>

<!-- Open source code -->

<!-- Compiled and minified JavaScript -->
  <script defer src="//maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>  
  <script defer src="//cdnjs.cloudflare.com/ajax/libs/jquery.form/3.51/jquery.form.min.js"></script>  
  <script defer src="//cdnjs.cloudflare.com/ajax/libs/parsley.js/2.6.0/parsley.min.js"></script>
  <script defer>
    $(document).ready(function(){
        $('[data-toggle="tooltip"]').tooltip(); 
    });
  </script>
  
</body>
</html>
