<?php
error_reporting(E_ERROR | E_PARSE);
date_default_timezone_set('asia/kolkata');
$dt = new DateTime(); 
function createZipArchive($files=array(), $destination='', $overwrite=false) {        
    if(file_exists($destination) && !$overwrite) { return false; }
    $validFiles=array();
    if(is_array($files)){        
        foreach ($files as $file) {
            if(file_exists($file)) {                
                $validFiles[] =$file;
            }
            //$validFiles[] =$file;
        }
    }
    if(count($validFiles)) {
        $zip=new ZipArchive();
        if($zip->open($destination,$overwrite? ZIPARCHIVE::OVERWRITE: ZIPARCHIVE::CREATE) ==true) {
            foreach($validFiles as $file) {                                
                $zip->addFile($file,basename($file));
                //$zip->setEncryptionName(basename($file), ZipArchive::EM_AES_256, 'password'); 
            }
            $zip->close();
            return file_exists($destination);
        }else{
            return false;
        }
    }else{
        return false;
    }
}
$path = __DIR__.'/Files'.'/';
$fileName= $dt->format('d-M-y')."All.zip";
$fileArr = scandir($path);
$files = array();
foreach($fileArr as $f){
    if($f != '' && $f != '.' && $f != '..'){
        $files[] = $path.$f;
    }
}
$result= createZipArchive($files, $fileName);
if($result){
    header("Content-Disposition: attachment; filename=".$fileName);
    header("Content-Length: ".filesize($fileName));    
    readfile($fileName);    
    unlink($fileName);    
    foreach($fileArr as $f){
        if($f != '' && $f != '.' && $f != '..'){
           unlink($path.$f);
        }
    }
}  
?>